/*
 * Decompiled with CFR 0.152.
 */
package com.helger.httpclient.response;

import com.helger.commons.string.StringHelper;
import com.helger.httpclient.HttpClientHelper;
import com.helger.httpclient.response.ResponseHandlerHttpEntity;
import com.helger.json.IJson;
import com.helger.json.serialize.JsonReader;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseHandlerJson
implements ResponseHandler<IJson> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResponseHandlerJson.class);
    private final boolean m_bDebugMode;

    public ResponseHandlerJson() {
        this(false);
    }

    public ResponseHandlerJson(boolean bl) {
        this.m_bDebugMode = bl;
    }

    public final boolean isDebugMode() {
        return this.m_bDebugMode;
    }

    @Override
    @Nullable
    public IJson handleResponse(@Nonnull HttpResponse httpResponse) throws IOException {
        HttpEntity httpEntity = ResponseHandlerHttpEntity.INSTANCE.handleResponse(httpResponse);
        if (httpEntity == null) {
            throw new ClientProtocolException("Response contains no content");
        }
        ContentType contentType = ContentType.getOrDefault(httpEntity);
        Charset charset = HttpClientHelper.getCharset(contentType);
        if (this.m_bDebugMode) {
            IJson iJson;
            String string = StringHelper.trim(EntityUtils.toString(httpEntity, charset));
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Got JSON: <" + string + ">");
            }
            if ((iJson = JsonReader.readFromString(string)) == null) {
                throw new IllegalArgumentException("Failed to parse as JSON: " + string);
            }
            return iJson;
        }
        return JsonReader.builder().setSource(httpEntity.getContent(), charset).read();
    }
}

