/*
 * Decompiled with CFR 0.152.
 */
package com.helger.httpclient.response;

import com.helger.httpclient.response.ExtendedHttpResponseException;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ResponseHandler;

public class ResponseHandlerHttpEntity
implements ResponseHandler<HttpEntity> {
    public static final ResponseHandlerHttpEntity INSTANCE = new ResponseHandlerHttpEntity();

    protected ResponseHandlerHttpEntity() {
    }

    @Override
    @Nullable
    public HttpEntity handleResponse(@Nonnull HttpResponse httpResponse) throws IOException {
        StatusLine statusLine = httpResponse.getStatusLine();
        HttpEntity httpEntity = httpResponse.getEntity();
        if (statusLine.getStatusCode() >= 300) {
            throw ExtendedHttpResponseException.create(statusLine, httpResponse, httpEntity);
        }
        return httpEntity;
    }
}

