/*
 * Decompiled with CFR 0.152.
 */
package com.helger.httpclient;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class HttpDebugger {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpDebugger.class);
    private static final AtomicBoolean s_aEnabled = new AtomicBoolean(false);

    private HttpDebugger() {
    }

    public static boolean isEnabled() {
        return s_aEnabled.get();
    }

    public static void setEnabled(boolean bl) {
        s_aEnabled.set(bl);
    }

    public static void beforeRequest(@Nonnull HttpUriRequest httpUriRequest, @Nullable HttpContext httpContext) {
        if (HttpDebugger.isEnabled() && LOGGER.isInfoEnabled()) {
            LOGGER.info("Before HTTP call: " + httpUriRequest.getMethod() + " " + httpUriRequest.getURI() + (httpContext != null ? " (with special HTTP context)" : ""));
        }
    }

    public static void afterRequest(@Nonnull HttpUriRequest httpUriRequest, @Nullable Object object, @Nullable Throwable throwable) {
        if (HttpDebugger.isEnabled() && LOGGER.isInfoEnabled()) {
            HttpResponseException httpResponseException = throwable instanceof HttpResponseException ? (HttpResponseException)throwable : null;
            LOGGER.info("After HTTP call: " + httpUriRequest.getMethod() + (object != null ? ". Response: " + object : "") + (httpResponseException != null ? ". Status " + httpResponseException.getStatusCode() : ""), httpResponseException != null ? null : throwable);
        }
    }
}

