/*
 * Decompiled with CFR 0.152.
 */
package com.helger.httpclient;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.httpclient.HttpClientFactory;
import com.helger.httpclient.HttpClientSettings;
import com.helger.httpclient.HttpDebugger;
import com.helger.httpclient.IHttpClientProvider;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;

public class HttpClientManager
implements AutoCloseable {
    private CloseableHttpClient m_aHttpClient;

    public HttpClientManager() {
        this(new HttpClientFactory());
    }

    public HttpClientManager(@Nonnull IHttpClientProvider iHttpClientProvider) {
        ValueEnforcer.notNull(iHttpClientProvider, "HttpClientSupplier");
        this.m_aHttpClient = iHttpClientProvider.createHttpClient();
        if (this.m_aHttpClient == null) {
            throw new IllegalArgumentException("The provided HttpClient factory created an invalid (null) HttpClient!");
        }
    }

    @Override
    public void close() {
        StreamHelper.close(this.m_aHttpClient);
        this.m_aHttpClient = null;
    }

    public final boolean isClosed() {
        return this.m_aHttpClient == null;
    }

    protected final void checkIfClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("This HttpClientManager was already closed!");
        }
    }

    @Nonnull
    public CloseableHttpResponse execute(@Nonnull HttpUriRequest httpUriRequest) throws IOException {
        return this.execute(httpUriRequest, (HttpContext)null);
    }

    @Nonnull
    public CloseableHttpResponse execute(@Nonnull HttpUriRequest httpUriRequest, @Nullable HttpContext httpContext) throws IOException {
        this.checkIfClosed();
        HttpDebugger.beforeRequest(httpUriRequest, httpContext);
        CloseableHttpResponse closeableHttpResponse = null;
        IOException iOException = null;
        try {
            CloseableHttpResponse closeableHttpResponse2 = closeableHttpResponse = this.m_aHttpClient.execute(httpUriRequest, httpContext);
            return closeableHttpResponse2;
        }
        catch (IOException iOException2) {
            iOException = iOException2;
            throw iOException2;
        }
        finally {
            HttpDebugger.afterRequest(httpUriRequest, closeableHttpResponse, iOException);
        }
    }

    @Nullable
    public <T> T execute(@Nonnull HttpUriRequest httpUriRequest, @Nonnull ResponseHandler<T> responseHandler) throws IOException {
        return this.execute(httpUriRequest, null, responseHandler);
    }

    @Nullable
    public <T> T execute(@Nonnull HttpUriRequest httpUriRequest, @Nullable HttpContext httpContext, @Nonnull ResponseHandler<T> responseHandler) throws IOException {
        this.checkIfClosed();
        HttpDebugger.beforeRequest(httpUriRequest, httpContext);
        T t = null;
        IOException iOException = null;
        try {
            T t2 = t = (T)this.m_aHttpClient.execute(httpUriRequest, responseHandler, httpContext);
            return t2;
        }
        catch (IOException iOException2) {
            iOException = iOException2;
            throw iOException2;
        }
        finally {
            HttpDebugger.afterRequest(httpUriRequest, t, iOException);
        }
    }

    @Nonnull
    public static HttpClientManager create(@Nonnull HttpClientSettings httpClientSettings) {
        return new HttpClientManager(new HttpClientFactory(httpClientSettings));
    }
}

