/*
 * Decompiled with CFR 0.152.
 */
package com.helger.httpclient;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.codec.URLCodec;
import com.helger.commons.http.EHttpMethod;
import com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import com.helger.commons.string.StringHelper;
import com.helger.commons.url.ISimpleURL;
import com.helger.network.proxy.config.HttpProxyConfig;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.protocol.HTTP;
import org.apache.http.protocol.HttpContext;

@Immutable
@SuppressFBWarnings(value={"JCIP_FIELD_ISNT_FINAL_IN_IMMUTABLE_CLASS"})
public final class HttpClientHelper {
    private HttpClientHelper() {
    }

    @Nonnull
    public static HttpRequestBase createRequest(@Nonnull EHttpMethod eHttpMethod, @Nonnull ISimpleURL iSimpleURL) {
        String string = iSimpleURL.getAsStringWithEncodedParameters();
        return HttpClientHelper.createRequest(eHttpMethod, string);
    }

    @Nonnull
    public static HttpRequestBase createRequest(@Nonnull EHttpMethod eHttpMethod, @Nonnull String string) {
        switch (eHttpMethod) {
            case DELETE: {
                return new HttpDelete(string);
            }
            case GET: {
                return new HttpGet(string);
            }
            case HEAD: {
                return new HttpHead(string);
            }
            case OPTIONS: {
                return new HttpOptions(string);
            }
            case TRACE: {
                return new HttpTrace(string);
            }
            case PATCH: {
                return new HttpPatch(string);
            }
            case POST: {
                return new HttpPost(string);
            }
            case PUT: {
                return new HttpPut(string);
            }
        }
        throw new IllegalStateException("Unsupported HTTP method: " + eHttpMethod);
    }

    @Nullable
    public static ContentType createContentType(@Nullable String string, @Nullable Charset charset) {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        return ContentType.create(string, charset);
    }

    @Nonnull
    public static Charset getCharset(@Nonnull ContentType contentType) {
        return HttpClientHelper.getCharset(contentType, HTTP.DEF_CONTENT_CHARSET);
    }

    @Nullable
    public static Charset getCharset(@Nonnull ContentType contentType, @Nullable Charset charset) {
        Charset charset2 = contentType.getCharset();
        return charset2 != null ? charset2 : charset;
    }

    @Nullable
    public static HttpHost createHttpHost(@Nullable Proxy proxy) {
        if (proxy != null && proxy.type() == Proxy.Type.HTTP && proxy.address() instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)proxy.address();
            return new HttpHost(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
        }
        return null;
    }

    @Nullable
    public static HttpHost createHttpHost(@Nullable HttpProxyConfig httpProxyConfig) {
        if (httpProxyConfig != null) {
            return new HttpHost(httpProxyConfig.getHost(), httpProxyConfig.getPort());
        }
        return null;
    }

    @Nullable
    public static Credentials createCredentials(@Nullable HttpProxyConfig httpProxyConfig) {
        if (httpProxyConfig != null && httpProxyConfig.hasUserNameOrPassword()) {
            return new UsernamePasswordCredentials(httpProxyConfig.getUserName(), httpProxyConfig.getPassword());
        }
        return null;
    }

    @Nonnull
    public static HttpContext createHttpContext(@Nullable HttpHost httpHost) {
        return HttpClientHelper.createHttpContext(httpHost, null);
    }

    @Nonnull
    public static HttpContext createHttpContext(@Nullable HttpHost httpHost, @Nullable Credentials credentials) {
        HttpClientContext httpClientContext = HttpClientContext.create();
        if (httpHost != null) {
            httpClientContext.setRequestConfig(RequestConfig.custom().setProxy(httpHost).build());
            if (credentials != null) {
                BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
                basicCredentialsProvider.setCredentials(new AuthScope(httpHost), credentials);
                httpClientContext.setCredentialsProvider(basicCredentialsProvider);
            }
        }
        return httpClientContext;
    }

    @Nullable
    public static HttpEntity createParameterEntity(@Nullable Map<String, String> map) {
        return HttpClientHelper.createParameterEntity(map, StandardCharsets.UTF_8);
    }

    @Nullable
    public static HttpEntity createParameterEntity(@Nullable Map<String, String> map, @Nonnull Charset charset) {
        ValueEnforcer.notNull(charset, "Charset");
        if (map == null || map.isEmpty()) {
            return null;
        }
        try (NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream(1024);){
            URLCodec uRLCodec = new URLCodec();
            boolean bl = true;
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (bl) {
                    bl = false;
                } else {
                    nonBlockingByteArrayOutputStream.write(38);
                }
                String string = entry.getKey();
                uRLCodec.encode(string.getBytes(charset), nonBlockingByteArrayOutputStream);
                String string2 = entry.getValue();
                if (!StringHelper.hasText(string2)) continue;
                nonBlockingByteArrayOutputStream.write(61);
                uRLCodec.encode(string2.getBytes(charset), nonBlockingByteArrayOutputStream);
            }
            InputStreamEntity inputStreamEntity = new InputStreamEntity(nonBlockingByteArrayOutputStream.getAsInputStream());
            return inputStreamEntity;
        }
    }
}

