/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http;

import com.helger.commons.string.StringHelper;
import com.helger.commons.string.StringParser;
import com.helger.http.AcceptLanguageList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class AcceptLanguageHandler {
    public static final String ANY_LANGUAGE = "*";
    private static final AcceptLanguageHandler s_aInstance = new AcceptLanguageHandler();

    private AcceptLanguageHandler() {
    }

    @Nonnull
    public static AcceptLanguageList getAcceptLanguages(@Nullable String string) {
        AcceptLanguageList acceptLanguageList = new AcceptLanguageList();
        if (StringHelper.hasNoText(string)) {
            acceptLanguageList.addLanguage(ANY_LANGUAGE, 1.0);
        } else {
            for (String string2 : StringHelper.getExploded(',', string)) {
                String[] stringArray = StringHelper.getExplodedArray(';', string2.trim(), 2);
                double d = 1.0;
                if (stringArray.length == 2 && stringArray[1].trim().startsWith("q=")) {
                    d = StringParser.parseDouble(stringArray[1].trim().substring(2), 1.0);
                }
                acceptLanguageList.addLanguage(stringArray[0], d);
            }
        }
        return acceptLanguageList;
    }
}

