/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http;

import com.helger.commons.ValueEnforcer;
import com.helger.http.AbstractQValueList;
import com.helger.http.QValue;
import java.util.Locale;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class AcceptEncodingList
extends AbstractQValueList<String> {
    @Nonnull
    private static String _unify(@Nonnull String string) {
        return string.toLowerCase(Locale.US);
    }

    public void addEncoding(@Nonnull String string, @Nonnegative double d) {
        ValueEnforcer.notEmpty(string, "Encoding");
        this.qvalueMap().put(AcceptEncodingList._unify(string), new QValue(d));
    }

    @Nonnull
    public QValue getQValueOfEncoding(@Nonnull String string) {
        ValueEnforcer.notNull(string, "Encoding");
        QValue qValue = (QValue)this.qvalueMap().get(AcceptEncodingList._unify(string));
        if (qValue == null && (qValue = (QValue)this.qvalueMap().get("*")) == null) {
            return QValue.MIN_QVALUE;
        }
        return qValue;
    }

    public double getQualityOfEncoding(@Nonnull String string) {
        return this.getQValueOfEncoding(string).getQuality();
    }

    public boolean supportsEncoding(@Nonnull String string) {
        return this.getQValueOfEncoding(string).isAboveMinimumQuality();
    }

    public boolean explicitlySupportsEncoding(@Nonnull String string) {
        ValueEnforcer.notNull(string, "Encoding");
        QValue qValue = (QValue)this.qvalueMap().get(AcceptEncodingList._unify(string));
        return qValue != null && qValue.isAboveMinimumQuality();
    }

    public boolean supportsGZIP() {
        return this.supportsEncoding("gzip") || this.supportsEncoding("x-gzip");
    }

    @Nullable
    public String getUsedGZIPEncoding() {
        if (this.supportsEncoding("gzip")) {
            return "gzip";
        }
        if (this.supportsEncoding("x-gzip")) {
            return "x-gzip";
        }
        return null;
    }

    public boolean supportsDeflate() {
        return this.supportsEncoding("deflate");
    }

    @Nullable
    public String getUsedDeflateEncoding() {
        if (this.supportsEncoding("deflate")) {
            return "deflate";
        }
        return null;
    }

    public boolean supportsCompress() {
        return this.supportsEncoding("compress") || this.supportsEncoding("x-compress");
    }

    @Nullable
    public String getUsedCompressEncoding() {
        if (this.supportsEncoding("compress")) {
            return "compress";
        }
        if (this.supportsEncoding("x-compress")) {
            return "x-compress";
        }
        return null;
    }
}

