/*
 * Decompiled with CFR 0.152.
 */
package com.helger.dns.dnsjava;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.ICommonsList;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.xbill.DNS.Name;
import org.xbill.DNS.config.ResolverConfigProvider;

public class CustomServerConfigProvider
implements ResolverConfigProvider {
    private final ICommonsList<InetSocketAddress> m_aServers;

    public CustomServerConfigProvider(@Nonnull ICommonsList<InetSocketAddress> iCommonsList) {
        ValueEnforcer.notNull(iCommonsList, "Servers");
        this.m_aServers = (ICommonsList)iCommonsList.getClone();
    }

    @Override
    public void initialize() {
    }

    @Override
    @Nonnull
    public List<InetSocketAddress> servers() {
        return (List)this.m_aServers.getClone();
    }

    @Override
    @Nonnull
    public List<Name> searchPaths() {
        return Collections.emptyList();
    }

    @Nonnull
    public static CustomServerConfigProvider createFromInetAddressList(@Nonnull ICommonsList<InetAddress> iCommonsList) {
        ValueEnforcer.notNull(iCommonsList, "Servers");
        return new CustomServerConfigProvider(iCommonsList.getAllMapped(inetAddress -> new InetSocketAddress((InetAddress)inetAddress, 53)));
    }
}

