/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.util;

import com.helger.commons.datetime.PDTConfig;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.exception.InitializationException;
import java.time.Clock;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class PDTXMLConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PDTXMLConverter.class);
    private static final DatatypeFactory s_aDTFactory;
    private static final PDTXMLConverter s_aInstance;

    private PDTXMLConverter() {
    }

    public static int getTimezoneOffsetInMinutes(int n) {
        return n / 60000;
    }

    public static int getTimezoneOffsetInMinutes(@Nonnull Calendar calendar) {
        int n = calendar.getTimeZone().getOffset(calendar.getTimeInMillis());
        return PDTXMLConverter.getTimezoneOffsetInMinutes(n);
    }

    @Nonnull
    public static GregorianCalendar getCalendar(@Nonnull Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(PDTFactory.getTimeZone(date), Locale.getDefault(Locale.Category.FORMAT));
        gregorianCalendar.setTime(date);
        return gregorianCalendar;
    }

    @Nonnull
    public static GregorianCalendar getCalendarDefaultTimeZone(long l) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(PDTConfig.getDefaultTimeZone(), Locale.getDefault(Locale.Category.FORMAT));
        gregorianCalendar.setTimeInMillis(l);
        return gregorianCalendar;
    }

    @Nonnull
    public static GregorianCalendar getCalendarUTC(long l) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(PDTConfig.getUTCTimeZone(), Locale.getDefault(Locale.Category.FORMAT));
        gregorianCalendar.setTimeInMillis(l);
        return gregorianCalendar;
    }

    @Nonnull
    public static XMLGregorianCalendar createNewCalendar() {
        return s_aDTFactory.newXMLGregorianCalendar();
    }

    @Nonnull
    public static XMLGregorianCalendar getXMLCalendarDateNow() {
        return PDTXMLConverter.getXMLCalendarDate(PDTFactory.getCurrentLocalDate());
    }

    @Nullable
    public static XMLGregorianCalendar getXMLCalendarDate(@Nullable LocalDate localDate) {
        return PDTXMLConverter.getXMLCalendarDate(localDate, Integer.MIN_VALUE);
    }

    @Nullable
    public static XMLGregorianCalendar getXMLCalendarDate(@Nullable LocalDate localDate, int n) {
        if (localDate == null) {
            return null;
        }
        return s_aDTFactory.newXMLGregorianCalendarDate(localDate.getYear(), localDate.getMonth().getValue(), localDate.getDayOfMonth(), n);
    }

    @Nullable
    public static XMLGregorianCalendar getXMLCalendarDate(@Nullable Date date) {
        if (date == null) {
            return null;
        }
        return PDTXMLConverter.getXMLCalendarDate(PDTXMLConverter.getCalendar(date));
    }

    @Nullable
    public static XMLGregorianCalendar getXMLCalendarDate(@Nullable GregorianCalendar gregorianCalendar) {
        if (gregorianCalendar == null) {
            return null;
        }
        return s_aDTFactory.newXMLGregorianCalendarDate(gregorianCalendar.get(1), gregorianCalendar.get(2) + 1, gregorianCalendar.get(5), PDTXMLConverter.getTimezoneOffsetInMinutes(gregorianCalendar));
    }

    @Nullable
    public static XMLGregorianCalendar getXMLCalendarDate(@Nullable XMLGregorianCalendar xMLGregorianCalendar) {
        if (xMLGregorianCalendar == null) {
            return null;
        }
        return s_aDTFactory.newXMLGregorianCalendarDate(xMLGregorianCalendar.getYear(), xMLGregorianCalendar.getMonth(), xMLGregorianCalendar.getDay(), xMLGregorianCalendar.getTimezone() == 0 ? Integer.MIN_VALUE : xMLGregorianCalendar.getTimezone());
    }

    @Nonnull
    public static XMLGregorianCalendar getXMLCalendarDate(int n, int n2, int n3) {
        return PDTXMLConverter.getXMLCalendarDate(n, n2, n3, Integer.MIN_VALUE);
    }

    @Nonnull
    public static XMLGregorianCalendar getXMLCalendarDate(int n, int n2, int n3, int n4) {
        return s_aDTFactory.newXMLGregorianCalendarDate(n, n2, n3, n4);
    }

    @Nonnull
    public static XMLGregorianCalendar getXMLCalendarTimeNow() {
        return PDTXMLConverter.getXMLCalendarTime(PDTFactory.getCurrentLocalTime());
    }

    @Nullable
    public static XMLGregorianCalendar getXMLCalendarTime(@Nullable LocalTime localTime) {
        if (localTime == null) {
            return null;
        }
        return s_aDTFactory.newXMLGregorianCalendarTime(localTime.getHour(), localTime.getMinute(), localTime.getSecond(), localTime.get(ChronoField.MILLI_OF_SECOND), Integer.MIN_VALUE);
    }

    @Nullable
    public static XMLGregorianCalendar getXMLCalendarTime(@Nullable Date date) {
        if (date == null) {
            return null;
        }
        return PDTXMLConverter.getXMLCalendarTime(PDTXMLConverter.getCalendar(date));
    }

    @Nullable
    public static XMLGregorianCalendar getXMLCalendarTime(@Nullable GregorianCalendar gregorianCalendar) {
        if (gregorianCalendar == null) {
            return null;
        }
        return s_aDTFactory.newXMLGregorianCalendarTime(gregorianCalendar.get(11), gregorianCalendar.get(12), gregorianCalendar.get(13), gregorianCalendar.get(14), PDTXMLConverter.getTimezoneOffsetInMinutes(gregorianCalendar));
    }

    @Nullable
    public static XMLGregorianCalendar getXMLCalendarTime(@Nullable XMLGregorianCalendar xMLGregorianCalendar) {
        if (xMLGregorianCalendar == null) {
            return null;
        }
        return s_aDTFactory.newXMLGregorianCalendarTime(xMLGregorianCalendar.getHour(), xMLGregorianCalendar.getMinute(), xMLGregorianCalendar.getSecond(), xMLGregorianCalendar.getMillisecond(), xMLGregorianCalendar.getTimezone());
    }

    @Nonnull
    public static XMLGregorianCalendar getXMLCalendarTime(int n, int n2, int n3, int n4) {
        return PDTXMLConverter.getXMLCalendarTime(n, n2, n3, n4, Integer.MIN_VALUE);
    }

    @Nonnull
    public static XMLGregorianCalendar getXMLCalendarTime(int n, int n2, int n3, int n4, int n5) {
        return s_aDTFactory.newXMLGregorianCalendarTime(n, n2, n3, n4, n5);
    }

    @Nonnull
    public static XMLGregorianCalendar getXMLCalendarNow() {
        return PDTXMLConverter.getXMLCalendar(PDTFactory.getCurrentZonedDateTime());
    }

    @Nonnull
    public static XMLGregorianCalendar getXMLCalendarNowUTC() {
        return PDTXMLConverter.getXMLCalendar(LocalDateTime.now(Clock.systemUTC()));
    }

    @Nullable
    public static XMLGregorianCalendar getXMLCalendar(@Nullable LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return null;
        }
        return s_aDTFactory.newXMLGregorianCalendar(localDateTime.getYear(), localDateTime.getMonth().getValue(), localDateTime.getDayOfMonth(), localDateTime.getHour(), localDateTime.getMinute(), localDateTime.getSecond(), localDateTime.get(ChronoField.MILLI_OF_SECOND), Integer.MIN_VALUE);
    }

    @Nullable
    public static XMLGregorianCalendar getXMLCalendar(@Nullable ZonedDateTime zonedDateTime) {
        if (zonedDateTime == null) {
            return null;
        }
        return s_aDTFactory.newXMLGregorianCalendar(GregorianCalendar.from(zonedDateTime));
    }

    @Nullable
    public static XMLGregorianCalendar getXMLCalendar(@Nullable GregorianCalendar gregorianCalendar) {
        if (gregorianCalendar == null) {
            return null;
        }
        return s_aDTFactory.newXMLGregorianCalendar(gregorianCalendar);
    }

    @Nullable
    public static XMLGregorianCalendar getXMLCalendar(@Nullable XMLGregorianCalendar xMLGregorianCalendar, @Nullable XMLGregorianCalendar xMLGregorianCalendar2) {
        if (xMLGregorianCalendar == null && xMLGregorianCalendar2 == null) {
            return null;
        }
        if (xMLGregorianCalendar2 == null) {
            return s_aDTFactory.newXMLGregorianCalendar(xMLGregorianCalendar.getYear(), xMLGregorianCalendar.getMonth(), xMLGregorianCalendar.getDay(), 0, 0, 0, 0, xMLGregorianCalendar.getTimezone());
        }
        if (xMLGregorianCalendar == null) {
            return s_aDTFactory.newXMLGregorianCalendar(0, 0, 0, xMLGregorianCalendar2.getHour(), xMLGregorianCalendar2.getMinute(), xMLGregorianCalendar2.getSecond(), xMLGregorianCalendar2.getMillisecond(), xMLGregorianCalendar2.getTimezone());
        }
        if (xMLGregorianCalendar.getTimezone() != xMLGregorianCalendar2.getTimezone()) {
            LOGGER.warn("Date and time have different timezones: " + xMLGregorianCalendar.getTimezone() + " vs. " + xMLGregorianCalendar2.getTimezone());
        }
        return s_aDTFactory.newXMLGregorianCalendar(xMLGregorianCalendar.getYear(), xMLGregorianCalendar.getMonth(), xMLGregorianCalendar.getDay(), xMLGregorianCalendar2.getHour(), xMLGregorianCalendar2.getMinute(), xMLGregorianCalendar2.getSecond(), xMLGregorianCalendar2.getMillisecond(), xMLGregorianCalendar.getTimezone());
    }

    @Nonnull
    public static XMLGregorianCalendar getXMLCalendar(long l) {
        return s_aDTFactory.newXMLGregorianCalendar(PDTXMLConverter.getCalendarDefaultTimeZone(l));
    }

    @Nonnull
    public static XMLGregorianCalendar getXMLCalendarUTC(long l) {
        return s_aDTFactory.newXMLGregorianCalendar(PDTXMLConverter.getCalendarUTC(l));
    }

    @Nullable
    public static XMLGregorianCalendar getXMLCalendar(@Nullable Date date) {
        if (date == null) {
            return null;
        }
        return s_aDTFactory.newXMLGregorianCalendar(PDTXMLConverter.getCalendar(date));
    }

    @Nullable
    public static GregorianCalendar getGregorianCalendar(@Nullable XMLGregorianCalendar xMLGregorianCalendar) {
        if (xMLGregorianCalendar == null) {
            return null;
        }
        return xMLGregorianCalendar.toGregorianCalendar(xMLGregorianCalendar.getTimeZone(xMLGregorianCalendar.getTimezone()), Locale.getDefault(Locale.Category.FORMAT), null);
    }

    @Nullable
    public static LocalDate getLocalDate(@Nullable XMLGregorianCalendar xMLGregorianCalendar) {
        if (xMLGregorianCalendar == null) {
            return null;
        }
        return PDTXMLConverter.getGregorianCalendar(xMLGregorianCalendar).toZonedDateTime().toLocalDate();
    }

    @Nullable
    public static LocalTime getLocalTime(@Nullable XMLGregorianCalendar xMLGregorianCalendar) {
        if (xMLGregorianCalendar == null) {
            return null;
        }
        return PDTXMLConverter.getGregorianCalendar(xMLGregorianCalendar).toZonedDateTime().toLocalTime();
    }

    @Nullable
    public static LocalDateTime getLocalDateTime(@Nullable XMLGregorianCalendar xMLGregorianCalendar) {
        if (xMLGregorianCalendar == null) {
            return null;
        }
        return PDTXMLConverter.getGregorianCalendar(xMLGregorianCalendar).toZonedDateTime().toLocalDateTime();
    }

    @Nullable
    public static ZonedDateTime getZonedDateTime(@Nullable XMLGregorianCalendar xMLGregorianCalendar) {
        if (xMLGregorianCalendar == null) {
            return null;
        }
        return PDTXMLConverter.getGregorianCalendar(xMLGregorianCalendar).toZonedDateTime();
    }

    @Nullable
    public static Date getDate(@Nullable XMLGregorianCalendar xMLGregorianCalendar) {
        GregorianCalendar gregorianCalendar = PDTXMLConverter.getGregorianCalendar(xMLGregorianCalendar);
        return gregorianCalendar == null ? null : gregorianCalendar.getTime();
    }

    @CheckForSigned
    public static long getMillis(@Nullable XMLGregorianCalendar xMLGregorianCalendar) {
        GregorianCalendar gregorianCalendar = PDTXMLConverter.getGregorianCalendar(xMLGregorianCalendar);
        return gregorianCalendar == null ? -1L : gregorianCalendar.getTimeInMillis();
    }

    static {
        try {
            s_aDTFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            throw new InitializationException("Failed to init DataTypeFactory", datatypeConfigurationException);
        }
        s_aInstance = new PDTXMLConverter();
    }
}

