/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.util;

import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.datetime.PDTToString;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PDTIOHelper {
    public static final String PATTERN_DATE = "uuuuMMdd";
    public static final String PATTERN_TIME = "HHmmss";
    public static final String PATTERN_DATETIME = "uuuuMMdd_HHmmss";
    private static final PDTIOHelper s_aInstance = new PDTIOHelper();

    private PDTIOHelper() {
    }

    @Nonnull
    public static String getCurrentLocalDateTimeForFilename() {
        return PDTIOHelper.getLocalDateTimeForFilename(PDTFactory.getCurrentLocalDateTime());
    }

    @Nonnull
    public static String getLocalDateTimeForFilename(@Nonnull LocalDateTime localDateTime) {
        return PDTToString.getAsString(PATTERN_DATETIME, localDateTime);
    }

    public static String getCurrentDateForFilename() {
        return PDTIOHelper.getDateForFilename(PDTFactory.getCurrentLocalDate());
    }

    public static String getDateForFilename(@Nonnull LocalDate localDate) {
        return PDTToString.getAsString(PATTERN_DATE, localDate);
    }

    public static String getCurrentTimeForFilename() {
        return PDTIOHelper.getTimeForFilename(PDTFactory.getCurrentLocalTime());
    }

    public static String getTimeForFilename(@Nonnull LocalTime localTime) {
        return PDTToString.getAsString(PATTERN_TIME, localTime);
    }
}

