/*
 * Decompiled with CFR 0.152.
 */
package com.helger.config.source.res;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.state.ESuccess;
import com.helger.commons.string.ToStringGenerator;
import com.helger.config.source.res.AbstractConfigurationSourceResource;
import com.helger.config.value.ConfiguredValue;
import com.helger.json.IJson;
import com.helger.json.IJsonArray;
import com.helger.json.IJsonObject;
import com.helger.json.serialize.JsonReader;
import java.nio.charset.Charset;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ConfigurationSourceJson
extends AbstractConfigurationSourceResource {
    public static final char LEVEL_SEPARATOR = '.';
    public static final String ARRAY_SUFFIX_COUNT = "$count";
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationSourceJson.class);
    private final Charset m_aCharset;
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private ICommonsOrderedMap<String, String> m_aProps;

    private static void _recursiveFlattenJson(@Nonnull String string, @Nonnull IJson iJson, @Nonnull Map<String, String> map) {
        if (iJson.isValue()) {
            map.put(string, iJson.getAsValue().getAsString());
        } else if (iJson.isObject()) {
            for (Map.Entry entry : iJson.getAsObject()) {
                ConfigurationSourceJson._recursiveFlattenJson(string + '.' + (String)entry.getKey(), (IJson)entry.getValue(), map);
            }
        } else {
            IJsonArray iJsonArray = iJson.getAsArray();
            map.put(string + '.' + ARRAY_SUFFIX_COUNT, Integer.toString(iJsonArray.size()));
            int n = 0;
            for (IJson iJson2 : iJsonArray) {
                ConfigurationSourceJson._recursiveFlattenJson(string + '.' + n, iJson2, map);
                ++n;
            }
        }
    }

    @Nullable
    private static ICommonsOrderedMap<String, String> _load(@Nonnull IReadableResource iReadableResource, @Nonnull Charset charset) {
        IJsonObject iJsonObject;
        JsonReader.Builder builder = JsonReader.builder().setSource(iReadableResource, charset).setCustomizeCallback(jsonParser -> jsonParser.setRequireStringQuotes(false).setAllowSpecialCharsInStrings(true).setAlwaysUseBigNumber(true).setTrackPosition(true)).setCustomExceptionCallback(jsonParseException -> LOGGER.error("Failed to parse '" + iReadableResource.getPath() + "' to JSON: " + jsonParseException.getMessage()));
        IJsonObject iJsonObject2 = iJsonObject = builder.hasSource() ? builder.readAsObject() : null;
        if (iJsonObject == null) {
            return null;
        }
        CommonsLinkedHashMap<String, String> commonsLinkedHashMap = new CommonsLinkedHashMap<String, String>();
        for (Map.Entry entry : iJsonObject) {
            ConfigurationSourceJson._recursiveFlattenJson((String)entry.getKey(), (IJson)entry.getValue(), commonsLinkedHashMap);
        }
        return commonsLinkedHashMap;
    }

    public ConfigurationSourceJson(@Nonnull IReadableResource iReadableResource) {
        this(SOURCE_TYPE.getDefaultPriority(), iReadableResource, null);
    }

    public ConfigurationSourceJson(@Nonnull IReadableResource iReadableResource, @Nullable Charset charset) {
        this(SOURCE_TYPE.getDefaultPriority(), iReadableResource, charset);
    }

    public ConfigurationSourceJson(int n, @Nonnull IReadableResource iReadableResource) {
        this(n, iReadableResource, null);
    }

    public ConfigurationSourceJson(int n, @Nonnull IReadableResource iReadableResource, @Nullable Charset charset) {
        super(n, iReadableResource);
        this.m_aCharset = charset != null ? charset : JsonReader.DEFAULT_CHARSET;
        this.m_aProps = ConfigurationSourceJson._load(iReadableResource, this.m_aCharset);
    }

    @Nonnull
    public final Charset getCharset() {
        return this.m_aCharset;
    }

    @Override
    public boolean isInitializedAndUsable() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aProps != null);
    }

    @Override
    @Nonnull
    public ESuccess reload() {
        ICommonsOrderedMap<String, String> iCommonsOrderedMap = ConfigurationSourceJson._load(this.getResource(), this.m_aCharset);
        this.m_aRWLock.writeLockedGet(() -> {
            this.m_aProps = iCommonsOrderedMap;
            return this.m_aProps;
        });
        return ESuccess.valueOf(iCommonsOrderedMap != null);
    }

    @Override
    @Nullable
    public ConfiguredValue getConfigurationValue(@Nonnull @Nonempty String string) {
        String string2 = this.m_aRWLock.readLockedGet(() -> this.m_aProps == null ? null : (String)this.m_aProps.get(string));
        return string2 == null ? null : new ConfiguredValue(this, string2);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, String> getAllConfigItems() {
        return this.m_aRWLock.readLockedGet(() -> new CommonsLinkedHashMap<String, String>((Map<String, String>)this.m_aProps));
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("Properties", this.m_aProps).getToString();
    }
}

