/*
 * Decompiled with CFR 0.152.
 */
package com.helger.config.source.res;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.string.ToStringGenerator;
import com.helger.config.source.AbstractConfigurationSource;
import com.helger.config.source.EConfigSourceType;
import com.helger.config.source.res.IConfigurationSourceResource;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public abstract class AbstractConfigurationSourceResource
extends AbstractConfigurationSource
implements IConfigurationSourceResource {
    public static final EConfigSourceType SOURCE_TYPE = EConfigSourceType.RESOURCE;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractConfigurationSourceResource.class);
    private final IReadableResource m_aRes;

    protected AbstractConfigurationSourceResource(int n, @Nonnull IReadableResource iReadableResource) {
        super(SOURCE_TYPE, n);
        ValueEnforcer.notNull(iReadableResource, "Resource");
        this.m_aRes = iReadableResource;
        File file = iReadableResource.getAsFile();
        if (file != null) {
            if (file.isFile()) {
                if (!file.canRead()) {
                    LOGGER.warn("The configuration file '" + file.getAbsolutePath() + "' exists, but is not readable");
                }
            } else if (file.isDirectory()) {
                LOGGER.warn("The configuration file '" + file.getAbsolutePath() + "' exists, but is a directory");
            }
        }
    }

    @Override
    @Nonnull
    public final IReadableResource getResource() {
        return this.m_aRes;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        AbstractConfigurationSourceResource abstractConfigurationSourceResource = (AbstractConfigurationSourceResource)object;
        return EqualsHelper.equals(this.m_aRes, abstractConfigurationSourceResource.m_aRes);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.m_aRes).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("Resource", this.m_aRes).getToString();
    }
}

