/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.lang;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.IsSPIImplementation;
import com.helger.commons.annotation.IsSPIInterface;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.cache.AnnotationUsageCache;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.lang.ClassLoaderHelper;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class ServiceLoaderHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceLoaderHelper.class);
    private static final AnnotationUsageCache s_aCacheInterface = new AnnotationUsageCache(IsSPIInterface.class);
    private static final AnnotationUsageCache s_aCacheImplementation = new AnnotationUsageCache(IsSPIImplementation.class);

    private ServiceLoaderHelper() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <T> ICommonsList<T> getAllSPIImplementations(@Nonnull Class<T> clazz) {
        return ServiceLoaderHelper.getAllSPIImplementations(clazz, ClassLoaderHelper.getDefaultClassLoader(), null);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <T> ICommonsList<T> getAllSPIImplementations(@Nonnull Class<T> clazz, @Nonnull ClassLoader classLoader) {
        return ServiceLoaderHelper.getAllSPIImplementations(clazz, classLoader, null);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <T> ICommonsList<T> getAllSPIImplementations(@Nonnull Class<T> clazz, @Nullable Logger logger) {
        return ServiceLoaderHelper.getAllSPIImplementations(clazz, ClassLoaderHelper.getDefaultClassLoader(), logger);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <T> ICommonsList<T> getAllSPIImplementations(@Nonnull Class<T> clazz, @Nonnull ClassLoader classLoader, @Nullable Logger logger) {
        Logger logger2;
        ValueEnforcer.notNull(clazz, "SPIClass");
        ValueEnforcer.notNull(classLoader, "ClassLoader");
        Logger logger3 = logger2 = logger != null ? logger : LOGGER;
        if (logger2.isTraceEnabled()) {
            logger2.trace("Trying to retrieve all SPI implementations of " + clazz);
        }
        if (!s_aCacheInterface.hasAnnotation(clazz) && LOGGER.isWarnEnabled()) {
            LOGGER.warn(clazz + " should have the @IsSPIInterface annotation");
        }
        ServiceLoader<T> serviceLoader = ServiceLoader.load(clazz, classLoader);
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        Iterator<T> iterator2 = serviceLoader.iterator();
        while (iterator2.hasNext()) {
            try {
                T t = iterator2.next();
                if (!s_aCacheImplementation.hasAnnotation(t) && LOGGER.isWarnEnabled()) {
                    LOGGER.warn(t + " should have the @IsSPIImplementation annotation");
                }
                commonsArrayList.add(t);
            }
            catch (Exception exception) {
                logger2.error("Unable to load an SPI implementation of " + clazz, exception);
            }
        }
        if (logger2.isDebugEnabled()) {
            logger2.debug("Finished retrieving all " + commonsArrayList.size() + " SPI implementations of " + clazz);
        }
        return commonsArrayList;
    }

    @Nullable
    public static <T> T getFirstSPIImplementation(@Nonnull Class<T> clazz) {
        return ServiceLoaderHelper.getFirstSPIImplementation(clazz, ClassLoaderHelper.getDefaultClassLoader(), null);
    }

    @Nullable
    public static <T> T getFirstSPIImplementation(@Nonnull Class<T> clazz, @Nonnull ClassLoader classLoader) {
        return ServiceLoaderHelper.getFirstSPIImplementation(clazz, classLoader, null);
    }

    @Nullable
    public static <T> T getFirstSPIImplementation(@Nonnull Class<T> clazz, @Nullable Logger logger) {
        return ServiceLoaderHelper.getFirstSPIImplementation(clazz, ClassLoaderHelper.getDefaultClassLoader(), logger);
    }

    @Nullable
    public static <T> T getFirstSPIImplementation(@Nonnull Class<T> clazz, @Nonnull ClassLoader classLoader, @Nullable Logger logger) {
        Logger logger2 = logger != null ? logger : LOGGER;
        ICommonsList<T> iCommonsList = ServiceLoaderHelper.getAllSPIImplementations(clazz, classLoader, logger2);
        if (iCommonsList.isEmpty()) {
            return null;
        }
        if (iCommonsList.size() > 1 && logger2.isWarnEnabled()) {
            logger2.warn("Requested only one SPI implementation of " + clazz + " but found " + iCommonsList.size() + " - using the first one. Details: " + iCommonsList);
        }
        return iCommonsList.getFirst();
    }
}

