/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.iterate;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.iterate.IIterableIterator;
import com.helger.commons.functional.IFunction;
import com.helger.commons.string.ToStringGenerator;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MapperIterator<SRCTYPE, ELEMENTTYPE>
implements IIterableIterator<ELEMENTTYPE> {
    private final Iterator<? extends SRCTYPE> m_aBaseIter;
    private final IFunction<? super SRCTYPE, ? extends ELEMENTTYPE> m_aConverter;

    public MapperIterator(@Nonnull IIterableIterator<? extends SRCTYPE> iIterableIterator, @Nonnull IFunction<? super SRCTYPE, ? extends ELEMENTTYPE> iFunction) {
        this(iIterableIterator.iterator(), iFunction);
    }

    public MapperIterator(@Nonnull Iterable<? extends SRCTYPE> iterable, @Nonnull IFunction<? super SRCTYPE, ? extends ELEMENTTYPE> iFunction) {
        this(iterable.iterator(), iFunction);
    }

    public MapperIterator(@Nonnull Iterator<? extends SRCTYPE> iterator2, @Nonnull IFunction<? super SRCTYPE, ? extends ELEMENTTYPE> iFunction) {
        this.m_aBaseIter = ValueEnforcer.notNull(iterator2, "BaseIterator");
        this.m_aConverter = ValueEnforcer.notNull(iFunction, "Filter");
    }

    @Nonnull
    public IFunction<? super SRCTYPE, ? extends ELEMENTTYPE> getConverter() {
        return this.m_aConverter;
    }

    @Override
    public boolean hasNext() {
        return this.m_aBaseIter.hasNext();
    }

    @Override
    @Nullable
    public ELEMENTTYPE next() {
        SRCTYPE SRCTYPE = this.m_aBaseIter.next();
        return (ELEMENTTYPE)this.m_aConverter.apply(SRCTYPE);
    }

    @Override
    public void remove() {
        this.m_aBaseIter.remove();
    }

    public String toString() {
        return new ToStringGenerator(this).append("BaseIter", this.m_aBaseIter).append("Converter", this.m_aConverter).getToString();
    }
}

