/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.iterate;

import com.helger.commons.collection.iterate.EmptyIterator;
import com.helger.commons.string.ToStringGenerator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class CombinedIterator<ELEMENTTYPE>
implements Iterator<ELEMENTTYPE> {
    private final Iterator<? extends ELEMENTTYPE> m_aIter1;
    private final Iterator<? extends ELEMENTTYPE> m_aIter2;
    private boolean m_bFirstIter;

    public CombinedIterator(@Nullable Iterator<? extends ELEMENTTYPE> iterator2, @Nullable Iterator<? extends ELEMENTTYPE> iterator3) {
        this.m_aIter1 = iterator2;
        this.m_aIter2 = iterator3;
        this.m_bFirstIter = iterator2 != null;
    }

    @Override
    public boolean hasNext() {
        boolean bl = false;
        if (this.m_bFirstIter && !(bl = this.m_aIter1.hasNext())) {
            this.m_bFirstIter = false;
        }
        if (!this.m_bFirstIter) {
            bl = this.m_aIter2 != null && this.m_aIter2.hasNext();
        }
        return bl;
    }

    @Override
    @Nullable
    public ELEMENTTYPE next() {
        if (this.m_bFirstIter) {
            return this.m_aIter1.next();
        }
        if (this.m_aIter2 == null) {
            throw new NoSuchElementException();
        }
        return this.m_aIter2.next();
    }

    @Override
    public void remove() {
        if (this.m_bFirstIter) {
            this.m_aIter1.remove();
        } else {
            if (this.m_aIter2 == null) {
                throw new UnsupportedOperationException();
            }
            this.m_aIter2.remove();
        }
    }

    public String toString() {
        return new ToStringGenerator(this).append("iter1", this.m_aIter1).append("iter2", this.m_aIter2).getToString();
    }

    @Nonnull
    public static <ELEMENTTYPE> Iterator<ELEMENTTYPE> create(@Nullable Iterator<ELEMENTTYPE> iterator2, @Nullable Iterator<ELEMENTTYPE> iterator3) {
        if (iterator2 == null && iterator3 == null) {
            return new EmptyIterator();
        }
        if (iterator2 == null) {
            return iterator3;
        }
        if (iterator3 == null) {
            return iterator2;
        }
        return new CombinedIterator<ELEMENTTYPE>(iterator2, iterator3);
    }
}

