/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.wrapped;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.ICommonsCollection;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class WrappedCollection<ELEMENTTYPE>
implements ICommonsCollection<ELEMENTTYPE> {
    @CodingStyleguideUnaware
    private final Collection<ELEMENTTYPE> m_aSrc;

    public WrappedCollection(@Nonnull Collection<ELEMENTTYPE> collection) {
        this.m_aSrc = ValueEnforcer.notNull(collection, "Set");
    }

    @Nonnull
    @ReturnsMutableObject(value="design")
    @CodingStyleguideUnaware
    protected Collection<ELEMENTTYPE> directGetSource() {
        return this.m_aSrc;
    }

    @Override
    public boolean add(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        return this.m_aSrc.add(ELEMENTTYPE);
    }

    @Override
    public boolean addAll(@Nonnull Collection<? extends ELEMENTTYPE> collection) {
        return this.m_aSrc.addAll(collection);
    }

    @Override
    public void clear() {
        this.m_aSrc.clear();
    }

    @Override
    public boolean contains(Object object) {
        return this.m_aSrc.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.m_aSrc.containsAll(collection);
    }

    @Override
    public boolean isEmpty() {
        return this.m_aSrc.isEmpty();
    }

    @Override
    public Iterator<ELEMENTTYPE> iterator() {
        return this.m_aSrc.iterator();
    }

    @Override
    public boolean remove(Object object) {
        return this.m_aSrc.remove(object);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.m_aSrc.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.m_aSrc.retainAll(collection);
    }

    @Override
    @Nonnegative
    public int size() {
        return this.m_aSrc.size();
    }

    @Override
    public Object[] toArray() {
        return this.m_aSrc.toArray();
    }

    @Override
    public <ARRAYELEMENTTYPE> ARRAYELEMENTTYPE[] toArray(ARRAYELEMENTTYPE[] ARRAYELEMENTTYPEArray) {
        return this.m_aSrc.toArray(ARRAYELEMENTTYPEArray);
    }

    @Override
    public boolean equals(Object object) {
        return this.m_aSrc.equals(object);
    }

    @Override
    public int hashCode() {
        return this.m_aSrc.hashCode();
    }

    public String toString() {
        return this.m_aSrc.toString();
    }
}

