/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.map;

import com.helger.collection.map.MapHelper;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.lang.IHasSize;
import java.io.Serializable;
import java.util.Arrays;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class IntDoubleMap
implements IHasSize,
Serializable {
    private static final int FREE_KEY = 0;
    public static final double NO_VALUE = Double.NEGATIVE_INFINITY;
    private int[] m_aKeys;
    private double[] m_aValues;
    private boolean m_bHasFreeKey;
    private double m_dFreeValue = Double.NEGATIVE_INFINITY;
    private final float m_fFillFactor;
    private int m_nThreshold;
    private int m_nSize;
    private int m_nMask;

    public IntDoubleMap() {
        this(16);
    }

    public IntDoubleMap(int n) {
        this(n, 0.75f);
    }

    public IntDoubleMap(int n, float f) {
        ValueEnforcer.isBetweenInclusive(f, "FillFactor", 0.0f, 1.0f);
        ValueEnforcer.isGT0(n, "Size");
        int n2 = MapHelper.arraySize(n, f);
        this.m_nMask = n2 - 1;
        this.m_fFillFactor = f;
        this.m_aKeys = new int[n2];
        this.m_aValues = IntDoubleMap._createValueArray(n2);
        this.m_nThreshold = (int)((float)n2 * f);
    }

    @Nonnull
    @ReturnsMutableCopy
    private static double[] _createValueArray(@Nonnegative int n) {
        double[] dArray = new double[n];
        Arrays.fill(dArray, Double.NEGATIVE_INFINITY);
        return dArray;
    }

    public double get(int n) {
        return this.get(n, Double.NEGATIVE_INFINITY);
    }

    public double get(int n, double d) {
        if (n == 0) {
            return this.m_bHasFreeKey ? this.m_dFreeValue : d;
        }
        int n2 = this._getReadIndex(n);
        return n2 != -1 ? this.m_aValues[n2] : d;
    }

    public double computeIfAbsent(int n, @Nonnull IKeyToValueFunction iKeyToValueFunction) {
        double d = this.get(n);
        if (d == Double.NEGATIVE_INFINITY && (d = iKeyToValueFunction.apply(n)) != Double.NEGATIVE_INFINITY) {
            this.put(n, d);
        }
        return d;
    }

    public double put(int n, double d) {
        if (n == 0) {
            double d2 = this.m_dFreeValue;
            if (!this.m_bHasFreeKey) {
                ++this.m_nSize;
                this.m_bHasFreeKey = true;
            }
            this.m_dFreeValue = d;
            return d2;
        }
        int n2 = this._getPutIndex(n);
        if (n2 < 0) {
            this._rehash(this.m_aKeys.length * 2);
            n2 = this._getPutIndex(n);
        }
        double d3 = this.m_aValues[n2];
        if (this.m_aKeys[n2] != n) {
            this.m_aKeys[n2] = n;
            this.m_aValues[n2] = d;
            ++this.m_nSize;
            if (this.m_nSize >= this.m_nThreshold) {
                this._rehash(this.m_aKeys.length * 2);
            }
        } else {
            if (this.m_aKeys[n2] != n) {
                throw new IllegalStateException();
            }
            this.m_aValues[n2] = d;
        }
        return d3;
    }

    public double remove(int n) {
        if (n == 0) {
            if (!this.m_bHasFreeKey) {
                return Double.NEGATIVE_INFINITY;
            }
            this.m_bHasFreeKey = false;
            double d = this.m_dFreeValue;
            this.m_dFreeValue = Double.NEGATIVE_INFINITY;
            --this.m_nSize;
            return d;
        }
        int n2 = this._getReadIndex(n);
        if (n2 == -1) {
            return Double.NEGATIVE_INFINITY;
        }
        double d = this.m_aValues[n2];
        this.m_aValues[n2] = Double.NEGATIVE_INFINITY;
        this._shiftKeys(n2);
        --this.m_nSize;
        return d;
    }

    @Override
    @Nonnegative
    public int size() {
        return this.m_nSize;
    }

    @Override
    public boolean isEmpty() {
        return this.m_nSize == 0;
    }

    private void _rehash(int n) {
        this.m_nThreshold = (int)((float)n * this.m_fFillFactor);
        this.m_nMask = n - 1;
        int n2 = this.m_aKeys.length;
        int[] nArray = this.m_aKeys;
        double[] dArray = this.m_aValues;
        this.m_aKeys = new int[n];
        this.m_aValues = IntDoubleMap._createValueArray(n);
        this.m_nSize = this.m_bHasFreeKey ? 1 : 0;
        int n3 = n2;
        while (n3 > 0) {
            if (nArray[--n3] == 0) continue;
            this.put(nArray[n3], dArray[n3]);
        }
    }

    private int _shiftKeys(int n) {
        int n2 = n;
        int[] nArray = this.m_aKeys;
        while (true) {
            int n3;
            int n4 = n2;
            n2 = this._getNextIndex(n2);
            while (true) {
                if ((n3 = nArray[n2]) == 0) {
                    nArray[n4] = 0;
                    this.m_aValues[n4] = Double.NEGATIVE_INFINITY;
                    return n4;
                }
                int n5 = MapHelper.phiMix(n3) & this.m_nMask;
                if (n4 <= n2 ? n4 >= n5 || n5 > n2 : n4 >= n5 && n5 > n2) break;
                n2 = this._getNextIndex(n2);
            }
            nArray[n4] = n3;
            this.m_aValues[n4] = this.m_aValues[n2];
        }
    }

    @CheckForSigned
    private int _getReadIndex(int n) {
        int n2 = MapHelper.phiMix(n) & this.m_nMask;
        if (this.m_aKeys[n2] == n) {
            return n2;
        }
        if (this.m_aKeys[n2] == 0) {
            return -1;
        }
        int n3 = n2;
        while ((n2 = this._getNextIndex(n2)) != n3) {
            if (this.m_aKeys[n2] == 0) {
                return -1;
            }
            if (this.m_aKeys[n2] != n) continue;
            return n2;
        }
        return -1;
    }

    @CheckForSigned
    private int _getPutIndex(int n) {
        int n2 = this._getReadIndex(n);
        if (n2 >= 0) {
            return n2;
        }
        int n3 = MapHelper.phiMix(n) & this.m_nMask;
        if (this.m_aKeys[n3] == 0) {
            return n3;
        }
        int n4 = n3;
        while (this.m_aKeys[n4] != 0) {
            if ((n4 = this._getNextIndex(n4)) != n3) continue;
            return -1;
        }
        return n4;
    }

    private int _getNextIndex(int n) {
        return n + 1 & this.m_nMask;
    }

    public void forEach(@Nonnull IConsumer iConsumer) {
        if (this.m_bHasFreeKey) {
            iConsumer.accept(0, this.m_dFreeValue);
        }
        int n = this.m_aKeys.length;
        for (int i = 0; i < n; ++i) {
            double d;
            int n2 = this.m_aKeys[i];
            if (n2 == 0 || (d = this.m_aValues[i]) == Double.NEGATIVE_INFINITY) continue;
            iConsumer.accept(n2, d);
        }
    }

    public static interface IConsumer {
        public void accept(int var1, double var2);
    }

    @FunctionalInterface
    public static interface IKeyToValueFunction
    extends Serializable {
        public double apply(int var1);
    }
}

