/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.iterate;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import java.util.Arrays;
import java.util.NoSuchElementException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public final class ArrayIteratorDouble {
    private final double[] m_aArray;
    private int m_nIndex = 0;

    public ArrayIteratorDouble(double ... dArray) {
        this(dArray, 0, dArray.length);
    }

    public ArrayIteratorDouble(@Nonnull double[] dArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isArrayOfsLen(dArray, n, n2);
        this.m_aArray = ArrayHelper.getCopy(dArray, n, n2);
    }

    public boolean hasNext() {
        return this.m_nIndex < this.m_aArray.length;
    }

    public double next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.m_aArray[this.m_nIndex++];
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ArrayIteratorDouble arrayIteratorDouble = (ArrayIteratorDouble)object;
        return EqualsHelper.equals(this.m_aArray, arrayIteratorDouble.m_aArray) && this.m_nIndex == arrayIteratorDouble.m_nIndex;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aArray).append(this.m_nIndex).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("array", Arrays.toString(this.m_aArray)).append("index", this.m_nIndex).getToString();
    }
}

