/*
 * Decompiled with CFR 0.152.
 */
package com.helger.bdve.engine.xsd;

import com.helger.bdve.api.EValidationType;
import com.helger.bdve.api.artefact.IValidationArtefact;
import com.helger.bdve.api.artefact.ValidationArtefact;
import com.helger.bdve.api.execute.AbstractValidationExecutor;
import com.helger.bdve.api.result.ValidationResult;
import com.helger.bdve.engine.source.IValidationSourceXML;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.error.SingleError;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.functional.ISupplier;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.location.SimpleLocation;
import com.helger.jaxb.builder.IJAXBDocumentType;
import com.helger.xml.sax.AbstractSAXErrorHandler;
import com.helger.xml.schema.XMLSchemaCache;
import com.helger.xml.schema.XMLSchemaValidationHelper;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.validation.Schema;
import org.xml.sax.SAXParseException;

public class ValidationExecutorXSD
extends AbstractValidationExecutor<IValidationSourceXML, ValidationExecutorXSD> {
    private final ISupplier<? extends Schema> m_aSchemaProvider;

    public ValidationExecutorXSD(@Nonnull IValidationArtefact iValidationArtefact, @Nonnull ISupplier<? extends Schema> iSupplier) {
        super(iValidationArtefact);
        ValueEnforcer.isTrue(iValidationArtefact.getValidationArtefactType().isXSD(), "Artifact is not an XSD");
        ValueEnforcer.notNull(iSupplier, "SchemaProvider");
        this.m_aSchemaProvider = iSupplier;
    }

    @Nonnull
    public final ISupplier<? extends Schema> getSchemaProvider() {
        return this.m_aSchemaProvider;
    }

    @Override
    @Nonnull
    public ValidationResult applyValidation(@Nonnull IValidationSourceXML iValidationSourceXML, @Nullable Locale locale) {
        ValueEnforcer.notNull(iValidationSourceXML, "Source");
        IValidationArtefact iValidationArtefact = this.getValidationArtefact();
        Schema schema2 = (Schema)this.m_aSchemaProvider.get();
        assert (schema2 != null);
        ErrorList errorList = new ErrorList();
        try {
            XMLSchemaValidationHelper.validate(schema2, iValidationSourceXML.getAsTransformSource(), errorList, locale);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (illegalArgumentException.getCause() instanceof SAXParseException) {
                errorList.add(AbstractSAXErrorHandler.getSaxParseError(EErrorLevel.FATAL_ERROR, (SAXParseException)illegalArgumentException.getCause()));
            }
            errorList.add(((SingleError.SingleErrorBuilder)((SingleError.SingleErrorBuilder)((SingleError.SingleErrorBuilder)SingleError.builderFatalError().setErrorLocation(new SimpleLocation(iValidationArtefact.getRuleResource().getPath()))).setErrorText("The document to be validated is not an XML document")).setLinkedException(illegalArgumentException)).build());
        }
        return new ValidationResult(iValidationArtefact, errorList.getAllFailures());
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Nonnull
    public static ValidationExecutorXSD create(@Nonnull IJAXBDocumentType iJAXBDocumentType) {
        ValueEnforcer.notNull(iJAXBDocumentType, "DocType");
        return new ValidationExecutorXSD(new ValidationArtefact(EValidationType.XSD, iJAXBDocumentType.getAllXSDResources().getLast()), iJAXBDocumentType::getSchema);
    }

    @Nonnull
    public static ValidationExecutorXSD create(@Nonnull IReadableResource iReadableResource) {
        ValueEnforcer.notNull(iReadableResource, "XSDRes");
        return new ValidationExecutorXSD(new ValidationArtefact(EValidationType.XSD, iReadableResource), () -> XMLSchemaCache.getInstance().getSchema(iReadableResource));
    }
}

