/*
 * Decompiled with CFR 0.152.
 */
package com.helger.bdve.api.executorset;

import com.helger.bdve.api.execute.IValidationExecutor;
import com.helger.bdve.api.executorset.IValidationExecutorSet;
import com.helger.bdve.api.executorset.VESID;
import com.helger.bdve.api.source.IValidationSource;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ValidationExecutorSet<SOURCETYPE extends IValidationSource>
implements IValidationExecutorSet<SOURCETYPE> {
    private final VESID m_aID;
    private final String m_sDisplayName;
    private final ICommonsList<IValidationExecutor<SOURCETYPE>> m_aList = new CommonsArrayList<IValidationExecutor<SOURCETYPE>>();
    private final boolean m_bDeprecated;

    public ValidationExecutorSet(@Nonnull VESID vESID, @Nonnull @Nonempty String string, boolean bl) {
        this.m_aID = ValueEnforcer.notNull(vESID, "ID");
        this.m_sDisplayName = ValueEnforcer.notEmpty(string, "DisplayName");
        this.m_bDeprecated = bl;
    }

    @Override
    @Nonnull
    public final VESID getID() {
        return this.m_aID;
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getDisplayName() {
        return this.m_sDisplayName;
    }

    @Override
    @Nonnull
    public final Iterator<IValidationExecutor<SOURCETYPE>> iterator() {
        return this.m_aList.iterator();
    }

    @Override
    @Nonnull
    @ReturnsMutableObject
    public final ICommonsList<IValidationExecutor<SOURCETYPE>> executors() {
        return this.m_aList;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<IValidationExecutor<SOURCETYPE>> getAllExecutors() {
        return (ICommonsList)this.m_aList.getClone();
    }

    @Override
    public final boolean isDeprecated() {
        return this.m_bDeprecated;
    }

    @Nonnull
    public ValidationExecutorSet<SOURCETYPE> addExecutor(@Nonnull IValidationExecutor<SOURCETYPE> iValidationExecutor) {
        ValueEnforcer.notNull(iValidationExecutor, "Executor");
        this.m_aList.add(iValidationExecutor);
        return this;
    }

    public void setValidationExecutorDoCache(boolean bl) {
        for (IValidationExecutor iValidationExecutor : this.m_aList) {
            if (!(iValidationExecutor instanceof IValidationExecutor.ICacheSupport)) continue;
            ((IValidationExecutor.ICacheSupport)((Object)iValidationExecutor)).setCacheArtefact(bl);
        }
    }

    @Nonnull
    public EChange removeAllExecutors() {
        return this.m_aList.removeAll();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ValidationExecutorSet validationExecutorSet = (ValidationExecutorSet)object;
        return this.m_aID.equals(validationExecutorSet.m_aID) && this.m_sDisplayName.equals(validationExecutorSet.m_sDisplayName) && this.m_aList.equals(validationExecutorSet.m_aList);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aID).append(this.m_sDisplayName).append(this.m_aList)).getHashCode();
    }

    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("ID", this.m_aID).append("DisplayName", this.m_sDisplayName).append("List", this.m_aList).getToString();
    }

    @Nonnull
    @SafeVarargs
    public static <ST extends IValidationSource> ValidationExecutorSet<ST> create(@Nonnull VESID vESID, @Nonnull @Nonempty String string, boolean bl, IValidationExecutor<ST> ... iValidationExecutorArray) {
        ValueEnforcer.notNull(vESID, "ID");
        ValueEnforcer.notEmpty(string, "DisplayName");
        ValueEnforcer.noNullValue(iValidationExecutorArray, "ValidationExecutors");
        ValidationExecutorSet<ST> validationExecutorSet = new ValidationExecutorSet<ST>(vESID, string, bl);
        for (IValidationExecutor<ST> iValidationExecutor : iValidationExecutorArray) {
            validationExecutorSet.addExecutor(iValidationExecutor);
        }
        return validationExecutorSet;
    }

    @Nonnull
    @SafeVarargs
    public static <ST extends IValidationSource> ValidationExecutorSet<ST> createDerived(@Nonnull IValidationExecutorSet<ST> iValidationExecutorSet, @Nonnull VESID vESID, @Nonnull @Nonempty String string, boolean bl, IValidationExecutor<ST> ... iValidationExecutorArray) {
        ValueEnforcer.notNull(iValidationExecutorSet, "BaseVES");
        ValueEnforcer.notNull(vESID, "ID");
        ValueEnforcer.notEmpty(string, "DisplayName");
        ValueEnforcer.notEmptyNoNullValue(iValidationExecutorArray, "ValidationExecutors");
        ValidationExecutorSet<ST> validationExecutorSet = new ValidationExecutorSet<ST>(vESID, string, bl);
        for (IValidationExecutor iValidationExecutor : iValidationExecutorSet) {
            validationExecutorSet.addExecutor(iValidationExecutor);
        }
        for (IValidationExecutor<ST> iValidationExecutor : iValidationExecutorArray) {
            validationExecutorSet.addExecutor(iValidationExecutor);
        }
        return validationExecutorSet;
    }
}

