/*
 * Decompiled with CFR 0.152.
 */
package com.helger.bdve.api.executorset;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.MustImplementComparable;
import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.compare.CompareHelper;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.RegEx;
import javax.annotation.concurrent.Immutable;

@Immutable
@MustImplementComparable
@MustImplementEqualsAndHashcode
public final class VESID
implements Comparable<VESID> {
    @RegEx
    public static final String REGEX_PART = "[a-zA-Z0-9_\\-\\.]+";
    public static final char ID_SEPARATOR = ':';
    private final String m_sGroupID;
    private final String m_sArtifactID;
    private final String m_sVersion;
    private final String m_sClassifier;
    private transient int m_nHashCode = 0;

    public static boolean isValidPart(@Nullable String string) {
        return StringHelper.hasText(string) && RegExHelper.stringMatchesPattern(REGEX_PART, string);
    }

    public VESID(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull @Nonempty String string3) {
        this(string, string2, string3, null);
    }

    public VESID(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull @Nonempty String string3, @Nullable String string4) {
        ValueEnforcer.notEmpty(string, "GroupID");
        ValueEnforcer.isTrue(VESID.isValidPart(string), () -> "GroupID '" + string + "' is invalid");
        ValueEnforcer.notEmpty(string2, "ArtifactID");
        ValueEnforcer.isTrue(VESID.isValidPart(string2), () -> "ArtifactID '" + string2 + "' is invalid");
        ValueEnforcer.notEmpty(string3, "Version");
        ValueEnforcer.isTrue(VESID.isValidPart(string3), () -> "Version '" + string3 + "' is invalid");
        if (StringHelper.hasText(string4)) {
            ValueEnforcer.isTrue(VESID.isValidPart(string4), () -> "Classifier '" + string4 + "' is invalid");
        }
        this.m_sGroupID = string;
        this.m_sArtifactID = string2;
        this.m_sVersion = string3;
        this.m_sClassifier = StringHelper.hasText(string4) ? string4 : null;
    }

    @Nonnull
    @Nonempty
    public String getGroupID() {
        return this.m_sGroupID;
    }

    @Nonnull
    @Nonempty
    public String getArtifactID() {
        return this.m_sArtifactID;
    }

    @Nonnull
    @Nonempty
    public String getVersion() {
        return this.m_sVersion;
    }

    public boolean hasClassifier() {
        return StringHelper.hasText(this.m_sClassifier);
    }

    @Nullable
    public String getClassifier() {
        return this.m_sClassifier;
    }

    @Nonnull
    public VESID getWithVersion(@Nonnull @Nonempty String string) {
        if (EqualsHelper.equals(this.m_sVersion, string)) {
            return this;
        }
        return new VESID(this.m_sGroupID, this.m_sArtifactID, string, this.m_sClassifier);
    }

    @Nonnull
    public VESID getWithClassifier(@Nullable String string) {
        if (EqualsHelper.equals(this.m_sClassifier, string)) {
            return this;
        }
        return new VESID(this.m_sGroupID, this.m_sArtifactID, this.m_sVersion, string);
    }

    @Nonnull
    @Nonempty
    public String getAsSingleID() {
        String string = this.m_sGroupID + ':' + this.m_sArtifactID + ':' + this.m_sVersion;
        if (this.hasClassifier()) {
            string = string + ':' + this.m_sClassifier;
        }
        return string;
    }

    @Override
    public int compareTo(VESID vESID) {
        int n = this.m_sGroupID.compareTo(vESID.m_sGroupID);
        if (n == 0 && (n = this.m_sArtifactID.compareTo(vESID.m_sArtifactID)) == 0 && (n = this.m_sVersion.compareTo(vESID.m_sVersion)) == 0) {
            n = CompareHelper.compare(this.m_sClassifier, vESID.m_sClassifier);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        VESID vESID = (VESID)object;
        return this.m_sGroupID.equals(vESID.m_sGroupID) && this.m_sArtifactID.equals(vESID.m_sArtifactID) && this.m_sVersion.equals(vESID.m_sVersion) && EqualsHelper.equals(this.m_sClassifier, vESID.m_sClassifier);
    }

    public int hashCode() {
        int n = this.m_nHashCode;
        if (n == 0) {
            n = this.m_nHashCode = new HashCodeGenerator(this).append(this.m_sGroupID).append(this.m_sArtifactID).append(this.m_sVersion).append(this.m_sClassifier).getHashCode();
        }
        return n;
    }

    public String toString() {
        return new ToStringGenerator(null).append("GroupID", this.m_sGroupID).append("ArtifactID", this.m_sArtifactID).append("Version", this.m_sVersion).appendIf("Classifier", this.m_sClassifier, StringHelper::hasText).getToString();
    }

    @Nonnull
    public static VESID parseID(@Nullable String string) {
        ICommonsList<String> iCommonsList = StringHelper.getExploded(':', string);
        int n = iCommonsList.size();
        if (n >= 3 && n <= 4) {
            return new VESID((String)iCommonsList.get(0), (String)iCommonsList.get(1), (String)iCommonsList.get(2), n >= 4 ? (String)iCommonsList.get(3) : null);
        }
        throw new IllegalArgumentException("Invalid VESID '" + string + "' provided!");
    }

    @Nullable
    public static VESID parseIDOrNull(@Nullable String string) {
        try {
            return VESID.parseID(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }
}

