/*
 * Decompiled with CFR 0.152.
 */
package com.helger.bdve.api.execute;

import com.helger.bdve.api.execute.IValidationExecutionManager;
import com.helger.bdve.api.execute.IValidationExecutor;
import com.helger.bdve.api.executorset.IValidationExecutorSet;
import com.helger.bdve.api.result.ValidationResult;
import com.helger.bdve.api.result.ValidationResultList;
import com.helger.bdve.api.source.IValidationSource;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsIterable;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.state.EValidity;
import java.util.Locale;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ValidationExecutionManager<SOURCETYPE extends IValidationSource>
implements IValidationExecutionManager<SOURCETYPE> {
    private final ICommonsList<IValidationExecutor<SOURCETYPE>> m_aExecutors = new CommonsArrayList<IValidationExecutor<SOURCETYPE>>();

    public ValidationExecutionManager() {
    }

    public ValidationExecutionManager(@Nullable Iterable<? extends IValidationExecutor<SOURCETYPE>> iterable) {
        this.addExecutors(iterable);
    }

    @Nonnull
    public final ValidationExecutionManager<SOURCETYPE> addExecutor(@Nonnull IValidationExecutor<SOURCETYPE> iValidationExecutor) {
        ValueEnforcer.notNull(iValidationExecutor, "Executor");
        this.m_aExecutors.add(iValidationExecutor);
        return this;
    }

    @Nonnull
    public final ValidationExecutionManager<SOURCETYPE> addExecutors(@Nullable Iterable<? extends IValidationExecutor<SOURCETYPE>> iterable) {
        if (iterable != null) {
            for (IValidationExecutor<SOURCETYPE> iValidationExecutor : iterable) {
                this.addExecutor(iValidationExecutor);
            }
        }
        return this;
    }

    @Nonnegative
    public int getExecutorCount() {
        return this.m_aExecutors.size();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IValidationExecutor<SOURCETYPE>> getAllExecutors() {
        return (ICommonsList)this.m_aExecutors.getClone();
    }

    @Nonnull
    public ICommonsIterable<IValidationExecutor<SOURCETYPE>> getExecutors() {
        return this.m_aExecutors;
    }

    @Override
    public void executeValidation(@Nonnull SOURCETYPE SOURCETYPE, @Nonnull ValidationResultList validationResultList, @Nullable Locale locale) {
        ValueEnforcer.notNull(SOURCETYPE, "Source");
        ValueEnforcer.notNull(validationResultList, "ValidationResults");
        boolean bl = false;
        for (IValidationExecutor iValidationExecutor : this.getAllExecutors()) {
            if (bl) {
                validationResultList.add(ValidationResult.createIgnoredResult(iValidationExecutor.getValidationArtefact()));
                continue;
            }
            ValidationResult validationResult = iValidationExecutor.applyValidation(SOURCETYPE, locale);
            assert (validationResult != null);
            validationResultList.add(validationResult);
            if (!validationResult.isFailure() || !iValidationExecutor.isStopValidationOnError()) continue;
            bl = true;
        }
    }

    @Override
    @Nonnull
    public EValidity executeFastValidation(@Nonnull SOURCETYPE SOURCETYPE) {
        ValueEnforcer.notNull(SOURCETYPE, "Source");
        for (IValidationExecutor iValidationExecutor : this.getAllExecutors()) {
            ValidationResult validationResult = iValidationExecutor.applyValidation(SOURCETYPE, null);
            if (!validationResult.isFailure()) continue;
            return EValidity.INVALID;
        }
        return EValidity.VALID;
    }

    @Nonnull
    public static <ST extends IValidationSource> ValidationResultList executeValidation(@Nonnull IValidationExecutorSet<ST> iValidationExecutorSet, @Nonnull ST ST) {
        return new ValidationExecutionManager<ST>(iValidationExecutorSet).executeValidation(ST);
    }

    @Nonnull
    public static <ST extends IValidationSource> ValidationResultList executeValidation(@Nonnull IValidationExecutorSet<ST> iValidationExecutorSet, @Nonnull ST ST, @Nullable Locale locale) {
        return new ValidationExecutionManager<ST>(iValidationExecutorSet).executeValidation(ST, locale);
    }

    @Nonnull
    public static <ST extends IValidationSource> void executeValidation(@Nonnull IValidationExecutorSet<ST> iValidationExecutorSet, @Nonnull ST ST, @Nonnull ValidationResultList validationResultList, @Nullable Locale locale) {
        new ValidationExecutionManager<ST>(iValidationExecutorSet).executeValidation(ST, validationResultList, locale);
    }

    @Nonnull
    public static <ST extends IValidationSource> EValidity executeFastValidation(@Nonnull IValidationExecutorSet<ST> iValidationExecutorSet, @Nonnull ST ST) {
        return new ValidationExecutionManager<ST>(iValidationExecutorSet).executeFastValidation(ST);
    }
}

