/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax2.ri;

import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.DTD;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.codehaus.stax2.XMLStreamWriter2;
import org.codehaus.stax2.evt.XMLEvent2;

public class Stax2EventWriterImpl
implements XMLEventWriter,
XMLStreamConstants {
    protected final XMLStreamWriter2 _writer;

    public Stax2EventWriterImpl(XMLStreamWriter2 xMLStreamWriter2) {
        this._writer = xMLStreamWriter2;
    }

    @Override
    public void add(XMLEvent xMLEvent) throws XMLStreamException {
        switch (xMLEvent.getEventType()) {
            case 10: {
                Attribute attribute = (Attribute)xMLEvent;
                QName qName = attribute.getName();
                this._writer.writeAttribute(qName.getPrefix(), qName.getNamespaceURI(), qName.getLocalPart(), attribute.getValue());
                break;
            }
            case 8: {
                this._writer.writeEndDocument();
                break;
            }
            case 2: {
                this._writer.writeEndElement();
                break;
            }
            case 13: {
                Namespace namespace = (Namespace)xMLEvent;
                this._writer.writeNamespace(namespace.getPrefix(), namespace.getNamespaceURI());
                break;
            }
            case 7: {
                StartDocument startDocument = (StartDocument)xMLEvent;
                if (!startDocument.encodingSet()) {
                    this._writer.writeStartDocument(startDocument.getVersion());
                    break;
                }
                this._writer.writeStartDocument(startDocument.getCharacterEncodingScheme(), startDocument.getVersion());
                break;
            }
            case 1: {
                Attribute attribute;
                StartElement startElement = xMLEvent.asStartElement();
                QName qName = startElement.getName();
                this._writer.writeStartElement(qName.getPrefix(), qName.getLocalPart(), qName.getNamespaceURI());
                Iterator<Attribute> iterator2 = startElement.getNamespaces();
                while (iterator2.hasNext()) {
                    attribute = iterator2.next();
                    this.add(attribute);
                }
                iterator2 = startElement.getAttributes();
                while (iterator2.hasNext()) {
                    attribute = iterator2.next();
                    this.add(attribute);
                }
                break;
            }
            case 4: {
                Characters characters = xMLEvent.asCharacters();
                String string = characters.getData();
                if (characters.isCData()) {
                    this._writer.writeCData(string);
                    break;
                }
                this._writer.writeCharacters(string);
                break;
            }
            case 12: {
                this._writer.writeCData(xMLEvent.asCharacters().getData());
                break;
            }
            case 5: {
                this._writer.writeComment(((Comment)xMLEvent).getText());
                break;
            }
            case 11: {
                this._writer.writeDTD(((DTD)xMLEvent).getDocumentTypeDeclaration());
                break;
            }
            case 9: {
                this._writer.writeEntityRef(((EntityReference)xMLEvent).getName());
                break;
            }
            case 3: {
                ProcessingInstruction processingInstruction = (ProcessingInstruction)xMLEvent;
                this._writer.writeProcessingInstruction(processingInstruction.getTarget(), processingInstruction.getData());
                break;
            }
            default: {
                if (xMLEvent instanceof XMLEvent2) {
                    ((XMLEvent2)xMLEvent).writeUsing(this._writer);
                    break;
                }
                throw new XMLStreamException("Don't know how to output event " + xMLEvent);
            }
        }
    }

    @Override
    public void add(XMLEventReader xMLEventReader) throws XMLStreamException {
        while (xMLEventReader.hasNext()) {
            this.add(xMLEventReader.nextEvent());
        }
    }

    @Override
    public void close() throws XMLStreamException {
        this._writer.close();
    }

    @Override
    public void flush() throws XMLStreamException {
        this._writer.flush();
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this._writer.getNamespaceContext();
    }

    @Override
    public String getPrefix(String string) throws XMLStreamException {
        return this._writer.getPrefix(string);
    }

    @Override
    public void setDefaultNamespace(String string) throws XMLStreamException {
        this._writer.setDefaultNamespace(string);
    }

    @Override
    public void setNamespaceContext(NamespaceContext namespaceContext) throws XMLStreamException {
        this._writer.setNamespaceContext(namespaceContext);
    }

    @Override
    public void setPrefix(String string, String string2) throws XMLStreamException {
        this._writer.setPrefix(string, string2);
    }
}

