/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util.introspection;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.reflect.TypeUtils;

public class IntrospectionUtils {
    static Map<Class, Class> boxingMap = new HashMap<Class, Class>();
    static Map<Class, Class> unboxingMap;

    public static Class getBoxedClass(Class clazz) {
        Class boxed = boxingMap.get(clazz);
        return boxed == null ? clazz : boxed;
    }

    public static Class getUnboxedClass(Class clazz) {
        Class unboxed = unboxingMap.get(clazz);
        return unboxed == null ? clazz : unboxed;
    }

    public static Class getTypeClass(Type type2) {
        Type[] bounds;
        if (type2 == null) {
            return null;
        }
        if (type2 instanceof Class) {
            return (Class)type2;
        }
        if (type2 instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type2).getRawType();
        }
        if (type2 instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type2).getGenericComponentType();
            Class componentClass = IntrospectionUtils.getTypeClass(componentType);
            if (componentClass != null) {
                return Array.newInstance(componentClass, 0).getClass();
            }
        } else if (type2 instanceof TypeVariable) {
            Type[] bounds2 = TypeUtils.getImplicitBounds((TypeVariable)type2);
            if (bounds2.length == 1) {
                return IntrospectionUtils.getTypeClass(bounds2[0]);
            }
        } else if (type2 instanceof WildcardType && (bounds = TypeUtils.getImplicitUpperBounds((WildcardType)type2)).length == 1) {
            return IntrospectionUtils.getTypeClass(bounds[0]);
        }
        return null;
    }

    public static boolean isMethodInvocationConvertible(Type formal, Class actual, boolean possibleVarArg) {
        Class formalClass = IntrospectionUtils.getTypeClass(formal);
        if (formalClass != null) {
            Class boxed;
            if (actual == null) {
                return !formalClass.isPrimitive();
            }
            if (formalClass.isAssignableFrom(actual)) {
                return true;
            }
            if (!formalClass.isPrimitive() && actual.isPrimitive() && ((boxed = boxingMap.get(actual)) != null && boxed == formalClass || formalClass.isAssignableFrom(boxed))) {
                return true;
            }
            if (formalClass.isPrimitive()) {
                if (actual.isPrimitive()) {
                    if (formalClass == Short.TYPE && actual == Byte.TYPE) {
                        return true;
                    }
                    if (formalClass == Integer.TYPE && (actual == Byte.TYPE || actual == Short.TYPE)) {
                        return true;
                    }
                    if (formalClass == Long.TYPE && (actual == Byte.TYPE || actual == Short.TYPE || actual == Integer.TYPE)) {
                        return true;
                    }
                    if (formalClass == Float.TYPE && (actual == Byte.TYPE || actual == Short.TYPE || actual == Integer.TYPE || actual == Long.TYPE)) {
                        return true;
                    }
                    if (formalClass == Double.TYPE && (actual == Byte.TYPE || actual == Short.TYPE || actual == Integer.TYPE || actual == Long.TYPE || actual == Float.TYPE)) {
                        return true;
                    }
                } else {
                    if (formalClass == Boolean.TYPE && actual == Boolean.class) {
                        return true;
                    }
                    if (formalClass == Character.TYPE && actual == Character.class) {
                        return true;
                    }
                    if (formalClass == Byte.TYPE && actual == Byte.class) {
                        return true;
                    }
                    if (formalClass == Short.TYPE && (actual == Short.class || actual == Byte.class)) {
                        return true;
                    }
                    if (formalClass == Integer.TYPE && (actual == Integer.class || actual == Short.class || actual == Byte.class)) {
                        return true;
                    }
                    if (formalClass == Long.TYPE && (actual == Long.class || actual == Integer.class || actual == Short.class || actual == Byte.class)) {
                        return true;
                    }
                    if (formalClass == Float.TYPE && (actual == Float.class || actual == Long.class || actual == Integer.class || actual == Short.class || actual == Byte.class)) {
                        return true;
                    }
                    if (formalClass == Double.TYPE && (actual == Double.class || actual == Float.class || actual == Long.class || actual == Integer.class || actual == Short.class || actual == Byte.class)) {
                        return true;
                    }
                }
            }
            if (possibleVarArg && formalClass.isArray()) {
                if (actual.isArray()) {
                    actual = actual.getComponentType();
                }
                return IntrospectionUtils.isMethodInvocationConvertible(formalClass.getComponentType(), actual, false);
            }
            return false;
        }
        if (TypeUtils.isAssignable((Type)actual, formal)) {
            return true;
        }
        return possibleVarArg && TypeUtils.isArrayType(formal) && TypeUtils.isAssignable((Type)actual, TypeUtils.getArrayComponentType(formal));
    }

    public static boolean isStrictMethodInvocationConvertible(Type formal, Class actual, boolean possibleVarArg) {
        Class formalClass = IntrospectionUtils.getTypeClass(formal);
        if (formalClass != null) {
            if (actual == null) {
                return !formalClass.isPrimitive();
            }
            if (formalClass.isAssignableFrom(actual)) {
                return true;
            }
            if (formalClass.isPrimitive()) {
                if (formal == Short.TYPE && actual == Byte.TYPE) {
                    return true;
                }
                if (formal == Integer.TYPE && (actual == Short.TYPE || actual == Byte.TYPE)) {
                    return true;
                }
                if (formal == Long.TYPE && (actual == Integer.TYPE || actual == Short.TYPE || actual == Byte.TYPE)) {
                    return true;
                }
                if (formal == Float.TYPE && (actual == Long.TYPE || actual == Integer.TYPE || actual == Short.TYPE || actual == Byte.TYPE)) {
                    return true;
                }
                if (formal == Double.TYPE && (actual == Float.TYPE || actual == Long.TYPE || actual == Integer.TYPE || actual == Short.TYPE || actual == Byte.TYPE)) {
                    return true;
                }
            }
            if (possibleVarArg && formalClass.isArray()) {
                if (actual.isArray()) {
                    actual = actual.getComponentType();
                }
                return IntrospectionUtils.isStrictMethodInvocationConvertible(formalClass.getComponentType(), actual, false);
            }
            return false;
        }
        if (TypeUtils.isAssignable((Type)actual, formal)) {
            return true;
        }
        return possibleVarArg && TypeUtils.isArrayType(formal) && TypeUtils.isAssignable((Type)actual, TypeUtils.getArrayComponentType(formal));
    }

    static {
        boxingMap.put(Boolean.TYPE, Boolean.class);
        boxingMap.put(Character.TYPE, Character.class);
        boxingMap.put(Byte.TYPE, Byte.class);
        boxingMap.put(Short.TYPE, Short.class);
        boxingMap.put(Integer.TYPE, Integer.class);
        boxingMap.put(Long.TYPE, Long.class);
        boxingMap.put(Float.TYPE, Float.class);
        boxingMap.put(Double.TYPE, Double.class);
        unboxingMap = new HashMap<Class, Class>();
        for (Map.Entry<Class, Class> entry : boxingMap.entrySet()) {
            unboxingMap.put(entry.getValue(), entry.getKey());
        }
    }
}

