/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol.types;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.protocol.types.BoundField;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.SchemaException;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;

public class Schema
extends Type {
    private final BoundField[] fields;
    private final Map<String, BoundField> fieldsByName;
    private final boolean tolerateMissingFieldsWithDefaults;

    public Schema(Field ... fs) {
        this(false, fs);
    }

    public Schema(boolean tolerateMissingFieldsWithDefaults, Field ... fs) {
        this.fields = new BoundField[fs.length];
        this.fieldsByName = new HashMap<String, BoundField>();
        this.tolerateMissingFieldsWithDefaults = tolerateMissingFieldsWithDefaults;
        for (int i = 0; i < this.fields.length; ++i) {
            Field def = fs[i];
            if (this.fieldsByName.containsKey(def.name)) {
                throw new SchemaException("Schema contains a duplicate field: " + def.name);
            }
            this.fields[i] = new BoundField(def, this, i);
            this.fieldsByName.put(def.name, this.fields[i]);
        }
    }

    @Override
    public void write(ByteBuffer buffer, Object o) {
        Struct r = (Struct)o;
        for (BoundField field : this.fields) {
            try {
                Object value = field.def.type.validate(r.get(field));
                field.def.type.write(buffer, value);
            }
            catch (Exception e) {
                throw new SchemaException("Error writing field '" + field.def.name + "': " + (e.getMessage() == null ? e.getClass().getName() : e.getMessage()));
            }
        }
    }

    @Override
    public Struct read(ByteBuffer buffer) {
        Object[] objects = new Object[this.fields.length];
        for (int i = 0; i < this.fields.length; ++i) {
            try {
                if (this.tolerateMissingFieldsWithDefaults) {
                    if (buffer.hasRemaining()) {
                        objects[i] = this.fields[i].def.type.read(buffer);
                        continue;
                    }
                    if (this.fields[i].def.hasDefaultValue) {
                        objects[i] = this.fields[i].def.defaultValue;
                        continue;
                    }
                    throw new SchemaException("Missing value for field '" + this.fields[i].def.name + "' which has no default value.");
                }
                objects[i] = this.fields[i].def.type.read(buffer);
                continue;
            }
            catch (Exception e) {
                throw new SchemaException("Error reading field '" + this.fields[i].def.name + "': " + (e.getMessage() == null ? e.getClass().getName() : e.getMessage()));
            }
        }
        return new Struct(this, objects);
    }

    @Override
    public int sizeOf(Object o) {
        int size = 0;
        Struct r = (Struct)o;
        for (BoundField field : this.fields) {
            try {
                size += field.def.type.sizeOf(r.get(field));
            }
            catch (Exception e) {
                throw new SchemaException("Error computing size for field '" + field.def.name + "': " + (e.getMessage() == null ? e.getClass().getName() : e.getMessage()));
            }
        }
        return size;
    }

    public int numFields() {
        return this.fields.length;
    }

    public BoundField get(int slot) {
        return this.fields[slot];
    }

    public BoundField get(String name) {
        return this.fieldsByName.get(name);
    }

    public BoundField[] fields() {
        return this.fields;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append('{');
        for (int i = 0; i < this.fields.length; ++i) {
            b.append(this.fields[i].toString());
            if (i >= this.fields.length - 1) continue;
            b.append(',');
        }
        b.append("}");
        return b.toString();
    }

    @Override
    public Struct validate(Object item) {
        try {
            Struct struct = (Struct)item;
            for (BoundField field : this.fields) {
                try {
                    field.def.type.validate(struct.get(field));
                }
                catch (SchemaException e) {
                    throw new SchemaException("Invalid value for field '" + field.def.name + "': " + e.getMessage());
                }
            }
            return struct;
        }
        catch (ClassCastException e) {
            throw new SchemaException("Not a Struct.");
        }
    }

    public void walk(Visitor visitor) {
        Objects.requireNonNull(visitor, "visitor must be non-null");
        Schema.handleNode(this, visitor);
    }

    private static void handleNode(Type node, Visitor visitor) {
        if (node instanceof Schema) {
            Schema schema2 = (Schema)node;
            visitor.visit(schema2);
            for (BoundField f : schema2.fields()) {
                Schema.handleNode(f.def.type, visitor);
            }
        } else if (node.isArray()) {
            visitor.visit(node);
            Schema.handleNode(node.arrayElementType().get(), visitor);
        } else {
            visitor.visit(node);
        }
    }

    public static abstract class Visitor {
        public void visit(Schema schema2) {
        }

        public void visit(Type field) {
        }
    }
}

