/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.http.util;

import io.javalin.http.UploadedFile;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.MultipartConfigElement;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00060\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0005H\u0002J\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00062\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0013"}, d2={"Lio/javalin/http/util/MultipartUtil;", "", "()V", "getFieldMap", "", "", "", "req", "Ljavax/servlet/http/HttpServletRequest;", "getPartValue", "partName", "getUploadedFiles", "Lio/javalin/http/UploadedFile;", "servletRequest", "isField", "", "filePart", "Ljavax/servlet/http/Part;", "isFile", "javalin"})
public final class MultipartUtil {
    public static final MultipartUtil INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<UploadedFile> getUploadedFiles(@NotNull HttpServletRequest servletRequest, @NotNull String partName) {
        void $this$mapTo$iv$iv;
        Part it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(servletRequest, "servletRequest");
        Intrinsics.checkParameterIsNotNull(partName, "partName");
        servletRequest.setAttribute("org.eclipse.jetty.multipartConfig", new MultipartConfigElement(System.getProperty("java.io.tmpdir")));
        Collection<Part> collection = servletRequest.getParts();
        Intrinsics.checkExpressionValueIsNotNull(collection, "servletRequest.parts");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Part)element$iv$iv;
            boolean bl = false;
            Part part = it;
            Intrinsics.checkExpressionValueIsNotNull(part, "it");
            if (!(INSTANCE.isFile(part) && Intrinsics.areEqual(it.getName(), partName))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void filePart;
            it = (Part)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            void v2 = filePart;
            Intrinsics.checkExpressionValueIsNotNull(v2, "filePart");
            InputStream inputStream = v2.getInputStream();
            Intrinsics.checkExpressionValueIsNotNull(inputStream, "filePart.inputStream");
            String string = filePart.getContentType();
            Intrinsics.checkExpressionValueIsNotNull(string, "filePart.contentType");
            int n = (int)filePart.getSize();
            String string2 = filePart.getSubmittedFileName();
            Intrinsics.checkExpressionValueIsNotNull(string2, "filePart.submittedFileName");
            String string3 = filePart.getSubmittedFileName();
            Intrinsics.checkExpressionValueIsNotNull(string3, "filePart.submittedFileName");
            UploadedFile uploadedFile = new UploadedFile(inputStream, string, n, string2, StringsKt.replaceBeforeLast$default(string3, ".", "", null, 4, null), filePart.getSize());
            collection2.add(uploadedFile);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, List<String>> getFieldMap(@NotNull HttpServletRequest req) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(req, "req");
        req.setAttribute("org.eclipse.jetty.multipartConfig", new MultipartConfigElement(System.getProperty("java.io.tmpdir")));
        Collection<Part> collection = req.getParts();
        Intrinsics.checkExpressionValueIsNotNull(collection, "req.parts");
        Iterable $this$associate$iv = collection;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Part part = (Part)element$iv$iv;
            boolean bl = false;
            Part part2 = part;
            Intrinsics.checkExpressionValueIsNotNull(part2, "part");
            String string = part2.getName();
            String string2 = part.getName();
            Intrinsics.checkExpressionValueIsNotNull(string2, "part.name");
            Pair<String, List<String>> pair = TuplesKt.to(string, INSTANCE.getPartValue(req, string2));
            boolean bl2 = false;
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getPartValue(HttpServletRequest req, String partName) {
        void $this$mapTo$iv$iv;
        Part it;
        Iterable $this$filterTo$iv$iv;
        Collection<Part> collection = req.getParts();
        Intrinsics.checkExpressionValueIsNotNull(collection, "req.parts");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Part)element$iv$iv;
            boolean bl = false;
            Part part = it;
            Intrinsics.checkExpressionValueIsNotNull(part, "it");
            if (!(INSTANCE.isField(part) && Intrinsics.areEqual(it.getName(), partName))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Charset charset;
            void filePart;
            it = (Part)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            void v2 = filePart;
            Intrinsics.checkExpressionValueIsNotNull(v2, "filePart");
            InputStream inputStream = v2.getInputStream();
            Intrinsics.checkExpressionValueIsNotNull(inputStream, "filePart.inputStream");
            byte[] byArray = ByteStreamsKt.readBytes(inputStream);
            Intrinsics.checkExpressionValueIsNotNull(Charset.forName("UTF-8"), "Charset.forName(\"UTF-8\")");
            boolean bl2 = false;
            boolean bl3 = false;
            String string = new String(byArray, charset);
            collection2.add(string);
        }
        return CollectionsKt.toList((List)destination$iv$iv);
    }

    private final boolean isField(Part filePart) {
        return filePart.getSubmittedFileName() == null;
    }

    private final boolean isFile(Part filePart) {
        return !this.isField(filePart);
    }

    private MultipartUtil() {
    }

    static {
        MultipartUtil multipartUtil;
        INSTANCE = multipartUtil = new MultipartUtil();
    }
}

