/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.regrep.slot;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.datetime.util.PDTXMLConverter;
import eu.toop.regrep.helper.VocabularyTerm;
import eu.toop.regrep.rim.InternationalStringType;
import eu.toop.regrep.rim.MapType;
import eu.toop.regrep.rim.SlotType;
import eu.toop.regrep.rim.ValueType;
import eu.toop.regrep.rim.VocabularyTermType;
import eu.toop.regrep.slot.ERegRepCollectionType;
import eu.toop.regrep.slot.SlotHelper;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.datatype.XMLGregorianCalendar;
import org.w3c.dom.Element;

@NotThreadSafe
public class SlotBuilder {
    private String m_sName;
    private ValueType m_aValue;

    @Nonnull
    public SlotBuilder setName(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Name");
        this.m_sName = string;
        return this;
    }

    @Nonnull
    public SlotBuilder setValue(@Nonnull ValueType valueType) {
        ValueEnforcer.notNull(valueType, "Value");
        this.m_aValue = valueType;
        return this;
    }

    @Nonnull
    public SlotBuilder setValue(@Nonnull Element element) {
        return this.setValue(SlotHelper.createSlotValue(element));
    }

    @Nonnull
    public SlotBuilder setValue(boolean bl) {
        return this.setValue(SlotHelper.createSlotValue(bl));
    }

    @Nonnull
    public SlotBuilder setValue(@Nullable ERegRepCollectionType eRegRepCollectionType, ValueType ... valueTypeArray) {
        return this.setValue(SlotHelper.createSlotValue(eRegRepCollectionType, valueTypeArray));
    }

    @Nonnull
    public SlotBuilder setValue(@Nullable ERegRepCollectionType eRegRepCollectionType, @Nullable Iterable<? extends ValueType> iterable) {
        return this.setValue(SlotHelper.createSlotValue(eRegRepCollectionType, iterable));
    }

    @Nonnull
    public SlotBuilder setValue(@Nonnull XMLGregorianCalendar xMLGregorianCalendar) {
        return this.setValue(SlotHelper.createSlotValue(xMLGregorianCalendar));
    }

    @Nonnull
    public SlotBuilder setValue(@Nonnull LocalDateTime localDateTime) {
        ValueEnforcer.notNull(localDateTime, "Value");
        return this.setValue(PDTXMLConverter.getXMLCalendar(localDateTime));
    }

    @Nonnull
    public SlotBuilder setValue(@Nonnull LocalDate localDate) {
        ValueEnforcer.notNull(localDate, "Value");
        return this.setValue(localDate.atStartOfDay());
    }

    @Nonnull
    public SlotBuilder setValue(@Nonnull ZonedDateTime zonedDateTime) {
        ValueEnforcer.notNull(zonedDateTime, "Value");
        return this.setValue(PDTXMLConverter.getXMLCalendar(zonedDateTime));
    }

    @Nonnull
    public SlotBuilder setValue(@Nonnull Date date) {
        ValueEnforcer.notNull(date, "Value");
        return this.setValue(PDTXMLConverter.getXMLCalendar(date));
    }

    @Nonnull
    public SlotBuilder setValue(float f) {
        return this.setValue(SlotHelper.createSlotValue(f));
    }

    @Nonnull
    public SlotBuilder setValue(@Nonnull BigInteger bigInteger) {
        return this.setValue(SlotHelper.createSlotValue(bigInteger));
    }

    @Nonnull
    public SlotBuilder setValue(int n) {
        return this.setValue(BigInteger.valueOf(n));
    }

    @Nonnull
    public SlotBuilder setValue(long l) {
        return this.setValue(BigInteger.valueOf(l));
    }

    @Nonnull
    public SlotBuilder setValue(@Nonnull InternationalStringType internationalStringType) {
        return this.setValue(SlotHelper.createSlotValue(internationalStringType));
    }

    @Nonnull
    public SlotBuilder setValue(@Nonnull MapType mapType) {
        return this.setValue(SlotHelper.createSlotValue(mapType));
    }

    @Nonnull
    public SlotBuilder setValue(@Nonnull SlotType slotType) {
        return this.setValue(SlotHelper.createSlotValue(slotType));
    }

    @Nonnull
    public SlotBuilder setValue(@Nonnull String string) {
        return this.setValue(SlotHelper.createSlotValue(string));
    }

    @Nonnull
    public SlotBuilder setVocabularyTermValue(@Nonnull String string, @Nonnull String string2) {
        return this.setValue(SlotHelper.createVocabularyTerm(string, string2));
    }

    @Nonnull
    public SlotBuilder setValue(@Nonnull VocabularyTerm vocabularyTerm) {
        return this.setValue(SlotHelper.createVocabularyTerm(vocabularyTerm));
    }

    @Nonnull
    public SlotBuilder setValue(@Nonnull VocabularyTermType vocabularyTermType) {
        return this.setValue(SlotHelper.createSlotValue(vocabularyTermType));
    }

    public boolean areAllMandatoryFieldsSet() {
        return this.m_sName != null && this.m_aValue != null;
    }

    @Nonnull
    public SlotType build() {
        if (this.m_sName == null) {
            throw new IllegalStateException("Name is missing");
        }
        if (this.m_aValue == null) {
            throw new IllegalStateException("Value is missing");
        }
        return SlotHelper.createSlot(this.m_sName, this.m_aValue);
    }
}

