/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.regrep;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import eu.toop.regrep.ERegRepResponseStatus;
import eu.toop.regrep.query.QueryRequest;
import eu.toop.regrep.query.QueryResponse;
import eu.toop.regrep.query.ResponseOptionType;
import eu.toop.regrep.rim.QueryType;
import eu.toop.regrep.rim.SlotType;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class RegRepHelper {
    private RegRepHelper() {
    }

    @Nonnull
    public static QueryRequest createEmptyQueryRequest() {
        QueryRequest queryRequest = new QueryRequest();
        queryRequest.setId(UUID.randomUUID().toString());
        queryRequest.setResponseOption(new ResponseOptionType());
        return queryRequest;
    }

    @Nonnull
    public static QueryRequest createQueryRequest(@Nonnull @Nonempty String string, SlotType ... slotTypeArray) {
        ValueEnforcer.notEmpty(string, "sQueryDefinition");
        ValueEnforcer.notEmptyNoNullValue(slotTypeArray, "Slots");
        QueryRequest queryRequest = RegRepHelper.createEmptyQueryRequest();
        QueryType queryType = new QueryType();
        queryType.setQueryDefinition(string);
        for (SlotType slotType : slotTypeArray) {
            queryType.addSlot(slotType);
        }
        queryRequest.setQuery(queryType);
        return queryRequest;
    }

    @Nonnull
    public static QueryResponse createEmptyQueryResponse(@Nonnull ERegRepResponseStatus eRegRepResponseStatus) {
        ValueEnforcer.notNull(eRegRepResponseStatus, "Status");
        QueryResponse queryResponse = new QueryResponse();
        queryResponse.setStatus(eRegRepResponseStatus.getID());
        return queryResponse;
    }

    @Nonnull
    public static QueryResponse createQueryResponse(@Nonnull ERegRepResponseStatus eRegRepResponseStatus, @Nullable String string, SlotType ... slotTypeArray) {
        QueryResponse queryResponse = RegRepHelper.createEmptyQueryResponse(eRegRepResponseStatus);
        queryResponse.setRequestId(string);
        for (SlotType slotType : slotTypeArray) {
            queryResponse.addSlot(slotType);
        }
        return queryResponse;
    }
}

