/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.playground.dp.service;

import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.typesafe.config.ConfigFactory;
import eu.toop.edm.EDMErrorResponse;
import eu.toop.edm.EDMRequest;
import eu.toop.edm.EDMResponse;
import eu.toop.edm.error.EDMExceptionPojo;
import eu.toop.edm.error.EEDMExceptionType;
import eu.toop.edm.error.EToopDataElementResponseErrorCode;
import eu.toop.edm.error.EToopErrorCode;
import eu.toop.edm.error.EToopErrorOrigin;
import eu.toop.edm.error.EToopErrorSeverity;
import eu.toop.edm.model.AddressPojo;
import eu.toop.edm.model.AgentPojo;
import eu.toop.edm.model.ConceptPojo;
import eu.toop.edm.request.IEDMRequestPayloadConcepts;
import eu.toop.edm.response.ResponseDocumentPojo;
import eu.toop.edm.response.ResponseDocumentReferencePojo;
import eu.toop.kafkaclient.ToopKafkaClient;
import eu.toop.playground.dp.DPException;
import eu.toop.playground.dp.DpConfig;
import eu.toop.playground.dp.datasource.GenericDocumentDataSource;
import eu.toop.playground.dp.datasource.RegisteredOrganizationDataSource;
import eu.toop.playground.dp.model.Attachment;
import eu.toop.playground.dp.model.DocumentDataset;
import eu.toop.playground.dp.model.EDMResponseWithAttachment;
import eu.toop.playground.dp.model.GBMDataset;
import eu.toop.regrep.ERegRepResponseStatus;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToopDP {
    public static final DpConfig APPCONFIG = new DpConfig(ConfigFactory.parseFile(Paths.get("ToopDP.conf", new String[0]).toFile()).resolve());
    private static final Logger LOGGER = LoggerFactory.getLogger(ToopDP.class);
    private final RegisteredOrganizationDataSource roDs;
    private final GenericDocumentDataSource gdDs;

    public ToopDP() {
        this(ToopDP.APPCONFIG.dp.datasetGBM, ToopDP.APPCONFIG.dp.datasetDocument);
    }

    public ToopDP(String string, String string2) {
        String string3;
        if (Files.notExists(Paths.get(string, new String[0]), new LinkOption[0])) {
            LOGGER.info("GBM concept dataset directory not found, creating directories and copying examples to {}", (Object)string);
            this.createExampleDataset(Paths.get(string, new String[0]), "datasets/gbm/example_LP.yaml");
            this.createExampleDataset(Paths.get(string, new String[0]), "datasets/gbm/example_LP_LR.yaml");
            this.createExampleDataset(Paths.get(string, new String[0]), "datasets/gbm/example_NP.yaml");
        }
        if (Files.notExists(Paths.get(string2, new String[0]), new LinkOption[0])) {
            LOGGER.info("Document dataset directory not found, creating directories and copying examples to {}", (Object)string2);
            this.createExampleDataset(Paths.get(string2, new String[0]), "datasets/document/example.yaml");
            this.createExampleDataset(Paths.get(string2, new String[0]), "datasets/document/example_LP.yaml");
            this.createExampleDataset(Paths.get(string2, new String[0]), "datasets/document/example_LP_JPEG.yaml");
            this.createExampleDataset(Paths.get(string2, new String[0]), "datasets/document/03a74657-c4c9-4a26-92ac-abf37e36c6ae.yaml");
            this.createExampleDataset(Paths.get(string2, new String[0]), "datasets/document/03e287f7-7500-446b-b360-1db78ffb2800.yaml");
            this.createExampleDataset(Paths.get(string2, new String[0]), "datasets/document/26bd0e98-108a-4d39-8553-d4f5693fcd41.yaml");
            this.createExampleDataset(Paths.get(string2, new String[0]), "datasets/document/622de68c-11a8-4006-adbf-4520f40693d0.yaml");
            this.createExampleDataset(Paths.get(string2, new String[0]), "datasets/document/516159d1-6d92-4806-b9ee-0d3b7d8996b9.yaml");
            this.createExampleDataset(Paths.get(string2, new String[0]), "datasets/document/a852053e-ba86-4690-86cf-7190a2f5d915.yaml");
        }
        if (Files.notExists(Paths.get(string3 = string2 + "/attachments", new String[0]), new LinkOption[0])) {
            LOGGER.info("Attachment directory not found, creating directories and copying examples to {}", (Object)string3);
            this.createExampleDataset(Paths.get(string3, new String[0]), "datasets/document/attachments/dummy.jpg");
            this.createExampleDataset(Paths.get(string3, new String[0]), "datasets/document/attachments/dummy.pdf");
            this.createExampleDataset(Paths.get(string3, new String[0]), "datasets/document/attachments/03a74657-c4c9-4a26-92ac-abf37e36c6ae.pdf");
            this.createExampleDataset(Paths.get(string3, new String[0]), "datasets/document/attachments/03e287f7-7500-446b-b360-1db78ffb2800.pdf");
            this.createExampleDataset(Paths.get(string3, new String[0]), "datasets/document/attachments/26bd0e98-108a-4d39-8553-d4f5693fcd41.pdf");
            this.createExampleDataset(Paths.get(string3, new String[0]), "datasets/document/attachments/622de68c-11a8-4006-adbf-4520f40693d0.pdf");
            this.createExampleDataset(Paths.get(string3, new String[0]), "datasets/document/attachments/516159d1-6d92-4806-b9ee-0d3b7d8996b9.pdf");
            this.createExampleDataset(Paths.get(string3, new String[0]), "datasets/document/attachments/a852053e-ba86-4690-86cf-7190a2f5d915.pdf");
        }
        this.roDs = new RegisteredOrganizationDataSource(string);
        this.gdDs = new GenericDocumentDataSource(string2);
    }

    public RegisteredOrganizationDataSource getRegisteredOrganizationDatasource() {
        return this.roDs;
    }

    public GenericDocumentDataSource getDocumentDatasource() {
        return this.gdDs;
    }

    public EDMResponse createEDMResponseFromRequest(EDMRequest eDMRequest) throws DPException {
        if (eDMRequest != null) {
            return this.createEDMResponseFromRequest(eDMRequest.getWriter().getAsBytes());
        }
        return this.createEDMResponseFromRequest((byte[])null);
    }

    public byte[] createXMLResponseFromRequest(byte[] byArray) throws DPException {
        return this.createEDMResponseFromRequest(byArray).getWriter().getAsBytes();
    }

    public EDMResponse createEDMResponseFromRequest(byte[] byArray) throws DPException {
        return this.createEDMResponseWithAttachmentsFromRequest(byArray).getEdmResponse();
    }

    public EDMResponseWithAttachment createEDMResponseWithAttachmentsFromRequest(EDMRequest eDMRequest) throws DPException {
        if (eDMRequest != null) {
            return this.createEDMResponseWithAttachmentsFromRequest(eDMRequest.getWriter().getAsBytes());
        }
        return this.createEDMResponseWithAttachmentsFromRequest((byte[])null);
    }

    public EDMResponseWithAttachment createEDMResponseWithAttachmentsFromRequest(byte[] byArray) throws DPException {
        EDMRequest eDMRequest = null;
        if (byArray != null) {
            eDMRequest = EDMRequest.reader().read(byArray);
        }
        if (eDMRequest == null) {
            LOGGER.warn("Got an EDMRequest that was not readable.");
            String string = "Unable to read the supplied request.";
            throw new DPException(EDMErrorResponse.builder().requestID("NONE").responseStatus(ERegRepResponseStatus.FAILURE).errorProvider(this.getMinimumDPInfo()).addException(EDMExceptionPojo.builder().timestampNow().errorCode(EToopErrorCode.GEN).errorMessage(string).errorOrigin(EToopErrorOrigin.REQUEST_RECEPTION).exceptionType(EEDMExceptionType.QUERY).severity(EToopErrorSeverity.FAILURE).build()).build(), string);
        }
        switch (eDMRequest.getQueryDefinition()) {
            case CONCEPT: {
                Object object;
                LOGGER.info("Got a concept EDMRequest. ID: " + eDMRequest.getRequestID());
                List list = this.roDs.findResponse(eDMRequest);
                if (list.size() > 0) {
                    if (list.size() > 1) {
                        LOGGER.warn("Found more than one suitable concept responses, creating a response for the first one.");
                    }
                    object = (GBMDataset)list.get(0);
                    LOGGER.info("Found a dataset for the EDMRequest. ID: " + eDMRequest.getRequestID());
                    if (eDMRequest.getPayloadProvider() instanceof IEDMRequestPayloadConcepts) {
                        IEDMRequestPayloadConcepts iEDMRequestPayloadConcepts = (IEDMRequestPayloadConcepts)eDMRequest.getPayloadProvider();
                        return new EDMResponseWithAttachment(((EDMResponse.BuilderConcept)((EDMResponse.BuilderConcept)((EDMResponse.BuilderConcept)((EDMResponse.BuilderConcept)EDMResponse.builderConcept().responseStatus(ERegRepResponseStatus.SUCCESS)).requestID(eDMRequest.getRequestID())).concept(ConceptPojo.builder(this.mergeConceptValues(((GBMDataset)object).getConceptPojoList(), iEDMRequestPayloadConcepts.getAllConcepts()).get(0))).issueDateTimeNow()).dataProvider(this.getDPInfo())).build(), null);
                    }
                }
                LOGGER.warn("Found no dataset for the EDMRequest. ID: " + eDMRequest.getRequestID());
                object = "Found no dataset for the supplied identifiers.";
                throw new DPException(EDMErrorResponse.builder().requestID(eDMRequest.getRequestID()).responseStatus(ERegRepResponseStatus.FAILURE).errorProvider(this.getMinimumDPInfo()).addException(EDMExceptionPojo.builder().timestampNow().errorCode(EToopErrorCode.GEN).errorMessage((String)object).errorOrigin(EToopErrorOrigin.RESPONSE_CREATION).exceptionType(EEDMExceptionType.OBJECT_NOT_FOUND).severity(EToopErrorSeverity.FAILURE).build()).build(), (String)object);
            }
            case DOCUMENT_BY_DISTRIBUTION: 
            case DOCUMENT_BY_ID: {
                LOGGER.info("Got a Document EDMRequest. ID: " + eDMRequest.getRequestID());
                List list = this.gdDs.findResponse(eDMRequest);
                if (list.size() > 0) {
                    LOGGER.info("Found a dataset for the EDMRequest. ID: " + eDMRequest.getRequestID());
                    switch (eDMRequest.getResponseOption()) {
                        case INLINE: {
                            LOGGER.info("Creating an Inline response.");
                            if (list.size() > 1) {
                                LOGGER.warn("Found more than one suitable document responses, creating a response for the first one.");
                            }
                            DocumentDataset documentDataset2 = (DocumentDataset)list.get(0);
                            return new EDMResponseWithAttachment(((EDMResponse.BuilderDocument)((EDMResponse.BuilderDocument)((EDMResponse.BuilderDocument)((EDMResponse.BuilderDocument)EDMResponse.builderDocument().responseStatus(ERegRepResponseStatus.SUCCESS)).requestID(eDMRequest.getRequestID())).addResponseObject(ResponseDocumentPojo.builder().registryObjectID(documentDataset2.getIDs().get(0)).dataset(documentDataset2.getAsDatasetPojo()).repositoryItemRef(documentDataset2.getRepositoryItemRef().getAsRepositoryItemRefPojo())).issueDateTimeNow()).dataProvider(this.getDPInfo())).build(), new Attachment(documentDataset2));
                        }
                        case REFERENCE: {
                            LOGGER.info("Creating an ObjectReference response.");
                            List list2 = list.stream().map(documentDataset -> ResponseDocumentReferencePojo.builder().registryObjectID(documentDataset.getIDs().get(0)).dataset(documentDataset.getAsDatasetPojo()).build()).collect(Collectors.toList());
                            return new EDMResponseWithAttachment(((EDMResponse.BuilderDocumentReference)((EDMResponse.BuilderDocumentReference)((EDMResponse.BuilderDocumentReference)((EDMResponse.BuilderDocumentReference)EDMResponse.builderDocumentReference().responseStatus(ERegRepResponseStatus.SUCCESS)).requestID(eDMRequest.getRequestID())).responseObjects(list2).issueDateTimeNow()).dataProvider(this.getDPInfo())).build(), null);
                        }
                    }
                }
                LOGGER.warn("Found no dataset for the EDMRequest. ID: " + eDMRequest.getRequestID());
                String string = "Found no dataset for the supplied identifiers.";
                throw new DPException(EDMErrorResponse.builder().requestID(eDMRequest.getRequestID()).responseStatus(ERegRepResponseStatus.FAILURE).errorProvider(this.getMinimumDPInfo()).addException(EDMExceptionPojo.builder().timestampNow().errorCode(EToopErrorCode.GEN).errorMessage(string).errorOrigin(EToopErrorOrigin.RESPONSE_CREATION).exceptionType(EEDMExceptionType.OBJECT_NOT_FOUND).severity(EToopErrorSeverity.FAILURE).build()).build(), string);
            }
        }
        return null;
    }

    private AgentPojo getDPInfo() {
        return AgentPojo.builder().name(APPCONFIG.getDp().getName()).id(APPCONFIG.getDp().getId()).idSchemeID(APPCONFIG.getDp().getIdSchemeID()).address(AddressPojo.builder().town(APPCONFIG.getDp().getAddress().getCity()).streetName(APPCONFIG.getDp().getAddress().getStreetName()).buildingNumber(APPCONFIG.getDp().getAddress().getBuildingNumber()).countryCode(APPCONFIG.getDp().getAddress().getCountryCode()).fullAddress(APPCONFIG.getDp().getAddress().getFullAddress()).postalCode(APPCONFIG.getDp().getAddress().getPostalCode()).build()).build();
    }

    private AgentPojo getMinimumDPInfo() {
        return AgentPojo.builder().name(APPCONFIG.getDp().getName()).id(APPCONFIG.getDp().getId()).idSchemeID(APPCONFIG.getDp().getIdSchemeID()).build();
    }

    public List<ConceptPojo> mergeConceptValues(List<ConceptPojo> list, List<ConceptPojo> list2) {
        ArrayList<ConceptPojo> arrayList = new ArrayList<ConceptPojo>();
        block0: for (ConceptPojo conceptPojo2 : list2) {
            for (ConceptPojo conceptPojo3 : list) {
                if (conceptPojo3.getName() == null || !conceptPojo3.getName().equals(conceptPojo2.getName())) continue;
                ConceptPojo.Builder builder = ConceptPojo.builder();
                builder.children(this.mergeConceptValues(conceptPojo3.children(), conceptPojo2.children()));
                ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, "Found and applied concepts for " + conceptPojo2.getName());
                arrayList.add(builder.id(conceptPojo2.getID()).name(conceptPojo2.getName()).value(conceptPojo3.getValue()).build());
                continue block0;
            }
        }
        return list2.stream().map(conceptPojo -> arrayList.stream().filter(conceptPojo2 -> Objects.equals(conceptPojo2.getName(), conceptPojo.getName())).findFirst().orElseGet(() -> {
            ToopKafkaClient.send((IErrorLevel)EErrorLevel.WARN, "Found unknown concept for " + conceptPojo.getName());
            return ConceptPojo.builder().id(conceptPojo.getID()).name(conceptPojo.getName()).valueErrorCode(EToopDataElementResponseErrorCode.DP_ELE_001).children(this.applyUnknownConceptStatus(conceptPojo.children())).build();
        })).collect(Collectors.toList());
    }

    private List<ConceptPojo> applyUnknownConceptStatus(List<ConceptPojo> list) {
        return list.stream().map(conceptPojo -> conceptPojo.cloneAndModify(builder -> {
            ToopKafkaClient.send((IErrorLevel)EErrorLevel.WARN, "Found unknown concept for " + conceptPojo.getName());
            builder.valueErrorCode(EToopDataElementResponseErrorCode.DP_ELE_001);
            builder.children(this.applyUnknownConceptStatus(builder.children()));
        })).collect(Collectors.toList());
    }

    private void createExampleDataset(Path path, String string) {
        block13: {
            try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(string);){
                Files.createDirectories(path, new FileAttribute[0]);
                byte[] byArray = new byte[inputStream.available()];
                if (inputStream.read(byArray) <= 0) break block13;
                File file = new File(path.toString(), Paths.get(string, new String[0]).getFileName().toString());
                try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                    fileOutputStream.write(byArray);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

