/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.playground.dp.datasource;

import eu.toop.edm.EDMRequest;
import eu.toop.edm.request.IEDMRequestPayloadDocumentID;
import eu.toop.playground.dp.model.Dataset;
import eu.toop.playground.dp.model.DocumentDataset;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public interface Datasource<T extends Dataset> {
    default public List<T> findResponse(EDMRequest eDMRequest) {
        return this.getDatasets().values().stream().filter(dataset -> eDMRequest.getDataSubjectLegalPerson() != null && dataset.getLegalPersonID() != null && dataset.getLegalPersonID().equals(this.toopIdentifierExtractor(eDMRequest.getDataSubjectLegalPerson().getID())) || eDMRequest.getDataSubjectLegalPerson() != null && dataset.getLegalPersonID() != null && dataset.getLegalPersonID().equals(this.toopIdentifierExtractor(eDMRequest.getDataSubjectLegalPerson().getLegalID())) || eDMRequest.getDataSubjectNaturalPerson() != null && dataset.getNaturalPersonID() != null && dataset.getNaturalPersonID().equals(this.toopIdentifierExtractor(eDMRequest.getDataSubjectNaturalPerson().getID()))).filter(dataset -> {
            if (eDMRequest.getAuthorizedRepresentative() != null && dataset.getLegalRepresentativeID() != null) {
                return dataset.getLegalRepresentativeID().equals(this.toopIdentifierExtractor(eDMRequest.getAuthorizedRepresentative().getID()));
            }
            return eDMRequest.getAuthorizedRepresentative() == null && dataset.getLegalRepresentativeID() == null;
        }).filter(dataset -> {
            if (eDMRequest.getPayloadProvider() instanceof IEDMRequestPayloadDocumentID && dataset instanceof DocumentDataset) {
                String string = ((IEDMRequestPayloadDocumentID)eDMRequest.getPayloadProvider()).getDocumentID();
                DocumentDataset documentDataset = (DocumentDataset)dataset;
                return string.equals(((DocumentDataset)dataset).getIDs().get(0));
            }
            return true;
        }).collect(Collectors.toList());
    }

    default public String toopIdentifierExtractor(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split("/");
        if (stringArray.length != 3) {
            return string;
        }
        return stringArray[2];
    }

    public Map<Path, T> getDatasets();
}

