/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.kafkaclient;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.ICommonsMap;
import eu.toop.kafkaclient.ToopKafkaManager;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ToopKafkaSettings {
    public static final String DEFAULT_KAFKA_TOPIC = "toop";
    private static final Logger LOGGER = LoggerFactory.getLogger(ToopKafkaSettings.class);
    private static final AtomicBoolean s_aLoggingEnabled = new AtomicBoolean(true);
    private static final AtomicBoolean s_aKafkaEnabled = new AtomicBoolean(false);
    private static final AtomicReference<String> s_aKafkaTopic = new AtomicReference<String>("toop");

    private ToopKafkaSettings() {
    }

    @Nonnull
    @ReturnsMutableObject
    public static ICommonsMap<String, String> defaultProperties() {
        return ToopKafkaManager.defaultProperties();
    }

    public static void setLoggingEnabled(boolean bl) {
        s_aLoggingEnabled.set(bl);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("TOOP Logging is now " + (bl ? "enabled" : "disabled"));
        }
    }

    public static boolean isLoggingEnabled() {
        return s_aLoggingEnabled.get();
    }

    public static void setKafkaEnabled(boolean bl) {
        s_aKafkaEnabled.set(bl);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("TOOP Kafka Client is now " + (bl ? "enabled" : "disabled"));
        }
    }

    public static boolean isKafkaEnabled() {
        return s_aKafkaEnabled.get();
    }

    public static void setKafkaTopic(@Nonnull String string) {
        ValueEnforcer.notNull(string, "Topic");
        s_aKafkaTopic.set(string);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Kafka Client is now set to topic: " + s_aKafkaTopic);
        }
    }

    @Nonnull
    public static String getKafkaTopic() {
        return s_aKafkaTopic.get();
    }
}

