/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.edm.xml;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.charset.CharsetHelper;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.stream.ByteBufferInputStream;
import com.helger.commons.io.stream.NonBlockingByteArrayInputStream;
import com.helger.commons.io.stream.NonBlockingStringReader;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.xml.EXMLParserFeature;
import com.helger.xml.sax.InputSourceFactory;
import com.helger.xml.serialize.read.SAXReaderFactory;
import com.helger.xml.serialize.read.SAXReaderSettings;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public interface IJAXBVersatileReader<T> {
    @Nullable
    default public T read(@Nonnull InputSource inputSource) {
        return this.read(new SAXReaderSettings(), inputSource);
    }

    @Nullable
    default public T read(@Nonnull SAXReaderSettings sAXReaderSettings, @Nonnull InputSource inputSource) {
        ValueEnforcer.notNull(sAXReaderSettings, "Settings");
        ValueEnforcer.notNull(inputSource, "InputSource");
        sAXReaderSettings.setFeatureValues(EXMLParserFeature.AVOID_XML_ATTACKS);
        XMLReader xMLReader = SAXReaderFactory.createXMLReader();
        sAXReaderSettings.applyToSAXReader(xMLReader);
        return this.read(new SAXSource(xMLReader, inputSource));
    }

    @Nullable
    default public T read(@Nonnull InputStream inputStream) {
        ValueEnforcer.notNull(inputStream, "InputStream");
        CharsetHelper.InputStreamAndCharset inputStreamAndCharset = CharsetHelper.getInputStreamAndCharsetFromBOM(inputStream);
        if (inputStreamAndCharset.hasCharset()) {
            return this.read(StreamHelper.createReader(inputStreamAndCharset.getInputStream(), inputStreamAndCharset.getCharset()));
        }
        return this.read(InputSourceFactory.create(inputStreamAndCharset.getInputStream()));
    }

    @Nullable
    default public T read(@Nonnull Reader reader) {
        ValueEnforcer.notNull(reader, "Reader");
        return this.read(InputSourceFactory.create(reader));
    }

    @Nullable
    default public T read(@Nonnull File file) {
        ValueEnforcer.notNull(file, "File");
        return this.read(InputSourceFactory.create(file));
    }

    @Nullable
    default public T read(@Nonnull Path path) {
        ValueEnforcer.notNull(path, "Path");
        return this.read(InputSourceFactory.create(path));
    }

    @Nullable
    default public T read(@Nonnull IReadableResource iReadableResource) {
        ValueEnforcer.notNull(iReadableResource, "Resource");
        return this.read(InputSourceFactory.create(iReadableResource));
    }

    @Nullable
    default public T read(@Nonnull IHasInputStream iHasInputStream) {
        ValueEnforcer.notNull(iHasInputStream, "Resource");
        return this.read(iHasInputStream.getInputStream());
    }

    @Nullable
    default public T read(@Nonnull byte[] byArray) {
        ValueEnforcer.notNull(byArray, "XML");
        return this.read(new NonBlockingByteArrayInputStream(byArray));
    }

    @Nullable
    default public T read(@Nonnull ByteBuffer byteBuffer) {
        ValueEnforcer.notNull(byteBuffer, "XML");
        return this.read(new ByteBufferInputStream(byteBuffer));
    }

    @Nullable
    default public T read(@Nonnull String string) {
        ValueEnforcer.notNull(string, "XML");
        return this.read(new NonBlockingStringReader(string));
    }

    @Nullable
    default public T read(@Nonnull char[] cArray) {
        ValueEnforcer.notNull(cArray, "XML");
        return this.read(new NonBlockingStringReader(cArray));
    }

    @Nullable
    public T read(@Nonnull Source var1);

    @Nullable
    public T read(@Nonnull Node var1);
}

