/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.edm.slot;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import eu.toop.edm.model.DistributionPojo;
import eu.toop.edm.xml.dcatap.DistributionMarshaller;
import eu.toop.regrep.rim.SlotType;
import eu.toop.regrep.slot.ERegRepCollectionType;
import eu.toop.regrep.slot.ISlotProvider;
import eu.toop.regrep.slot.SlotBuilder;
import eu.toop.regrep.slot.SlotHelper;
import javax.annotation.Nonnull;

public class SlotDistributionRequestList
implements ISlotProvider {
    public static final String NAME = "DistributionRequestList";
    private final ICommonsList<DistributionPojo> m_aDistributions = new CommonsArrayList<DistributionPojo>();

    public SlotDistributionRequestList(DistributionPojo ... distributionPojoArray) {
        ValueEnforcer.noNullValue(distributionPojoArray, "Distributions");
        this.m_aDistributions.addAll((DistributionPojo[])distributionPojoArray);
    }

    public SlotDistributionRequestList(@Nonnull Iterable<DistributionPojo> iterable) {
        ValueEnforcer.noNullValue(iterable, "Distributions");
        this.m_aDistributions.addAll(iterable);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getName() {
        return NAME;
    }

    @Override
    @Nonnull
    public SlotType createSlot() {
        DistributionMarshaller distributionMarshaller = new DistributionMarshaller();
        return new SlotBuilder().setName(NAME).setValue(ERegRepCollectionType.SORTED_SET, this.m_aDistributions.getAllMapped(distributionPojo -> SlotHelper.createSlotValue(distributionMarshaller.getAsDocument(distributionPojo.getAsDistribution()).getDocumentElement()))).build();
    }
}

