/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.edm.model;

import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.xsds.ccts.cct.schemamodule.TextType;
import eu.toop.edm.jaxb.cv.agent.AgentType;
import eu.toop.edm.jaxb.cv.agent.LocationType;
import eu.toop.edm.jaxb.cv.cbc.IDType;
import eu.toop.edm.jaxb.cv.cbc.NameType;
import eu.toop.edm.jaxb.w3.locn.AddressType;
import eu.toop.edm.model.AddressPojo;
import eu.toop.edm.model.EToopIdentifierType;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@Immutable
public class AgentPojo {
    private final String m_sID;
    private final String m_sIDSchemeID;
    private final String m_sName;
    private final AddressPojo m_aAddress;

    public AgentPojo(@Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable AddressPojo addressPojo) {
        this.m_sID = string;
        this.m_sIDSchemeID = string2;
        this.m_sName = string3;
        this.m_aAddress = addressPojo;
    }

    @Nullable
    public final String getID() {
        return this.m_sID;
    }

    @Nullable
    public final String getIDSchemeID() {
        return this.m_sIDSchemeID;
    }

    @Nullable
    public final String getName() {
        return this.m_sName;
    }

    @Nullable
    public final AddressPojo getAddress() {
        return this.m_aAddress;
    }

    @Nonnull
    public AgentType getAsAgent() {
        IExplicitlyCloneable iExplicitlyCloneable;
        AgentType agentType = new AgentType();
        if (StringHelper.hasText(this.m_sID)) {
            iExplicitlyCloneable = new IDType();
            iExplicitlyCloneable.setValue(this.m_sID);
            iExplicitlyCloneable.setSchemeID(this.m_sIDSchemeID);
            agentType.addId((IDType)iExplicitlyCloneable);
        }
        if (StringHelper.hasText(this.m_sName)) {
            iExplicitlyCloneable = new NameType();
            ((TextType)iExplicitlyCloneable).setValue(this.m_sName);
            agentType.addName((NameType)iExplicitlyCloneable);
        }
        if (this.m_aAddress != null && (iExplicitlyCloneable = this.m_aAddress.getAsAgentAddress()) != null) {
            LocationType locationType = new LocationType();
            locationType.setAddress((AddressType)iExplicitlyCloneable);
            agentType.addLocation(locationType);
        }
        return agentType;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AgentPojo agentPojo = (AgentPojo)object;
        return EqualsHelper.equals(this.m_sID, agentPojo.m_sID) && EqualsHelper.equals(this.m_sIDSchemeID, agentPojo.m_sIDSchemeID) && EqualsHelper.equals(this.m_sName, agentPojo.m_sName) && EqualsHelper.equals(this.m_aAddress, agentPojo.m_aAddress);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sID).append(this.m_sIDSchemeID).append(this.m_sName).append(this.m_aAddress).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("ID", this.m_sID).append("IDSchemeID", this.m_sIDSchemeID).append("Name", this.m_sName).append("Address", this.m_aAddress).getToString();
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Nonnull
    public static Builder builder(@Nullable AgentType agentType) {
        Builder builder = new Builder();
        if (agentType != null) {
            if (agentType.hasIdEntries()) {
                builder.id(agentType.getIdAtIndex(0).getValue()).idSchemeID(agentType.getIdAtIndex(0).getSchemeID());
            }
            if (agentType.hasNameEntries()) {
                builder.name(agentType.getNameAtIndex(0).getValue());
            }
            if (agentType.hasLocationEntries()) {
                builder.address(AddressPojo.builder(agentType.getLocationAtIndex(0).getAddress()));
            }
        }
        return builder;
    }

    @NotThreadSafe
    public static class Builder {
        private String m_sID;
        private String m_sIDSchemeID;
        private String m_sName;
        private AddressPojo m_aAddress;

        @Nonnull
        public Builder id(@Nullable String string) {
            this.m_sID = string;
            return this;
        }

        @Nonnull
        public Builder idSchemeID(@Nullable EToopIdentifierType eToopIdentifierType) {
            return this.idSchemeID(eToopIdentifierType == null ? null : eToopIdentifierType.getID());
        }

        @Nonnull
        public Builder idSchemeID(@Nullable String string) {
            this.m_sIDSchemeID = string;
            return this;
        }

        @Nonnull
        public Builder name(@Nullable String string) {
            this.m_sName = string;
            return this;
        }

        @Nonnull
        public Builder address(@Nullable Consumer<? super AddressPojo.Builder> consumer) {
            if (consumer != null) {
                AddressPojo.Builder builder = AddressPojo.builder();
                consumer.accept(builder);
                this.address(builder);
            }
            return this;
        }

        @Nonnull
        public Builder address(@Nullable AddressPojo.Builder builder) {
            return this.address(builder == null ? null : builder.build());
        }

        @Nonnull
        public Builder address(@Nullable AddressPojo addressPojo) {
            this.m_aAddress = addressPojo;
            return this;
        }

        @Nonnull
        public AgentPojo build() {
            return new AgentPojo(this.m_sID, this.m_sIDSchemeID, this.m_sName, this.m_aAddress);
        }
    }
}

