/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.edm;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.CommonsLinkedHashSet;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.jaxb.IJAXBWriter;
import eu.toop.edm.IEDMTopLevelObject;
import eu.toop.edm.error.EDMExceptionPojo;
import eu.toop.edm.jaxb.cv.agent.AgentType;
import eu.toop.edm.model.AgentPojo;
import eu.toop.edm.slot.SlotErrorProvider;
import eu.toop.edm.slot.SlotSpecificationIdentifier;
import eu.toop.edm.xml.IJAXBVersatileReader;
import eu.toop.edm.xml.IVersatileWriter;
import eu.toop.edm.xml.JAXBVersatileReader;
import eu.toop.edm.xml.JAXBVersatileWriter;
import eu.toop.edm.xml.cagv.AgentMarshaller;
import eu.toop.edm.xml.cccev.CCCEV;
import eu.toop.regrep.ERegRepResponseStatus;
import eu.toop.regrep.RegRep4Reader;
import eu.toop.regrep.RegRep4Writer;
import eu.toop.regrep.RegRepHelper;
import eu.toop.regrep.query.QueryResponse;
import eu.toop.regrep.rim.AnyValueType;
import eu.toop.regrep.rim.SlotType;
import eu.toop.regrep.rim.StringValueType;
import eu.toop.regrep.rim.ValueType;
import eu.toop.regrep.rs.RegistryExceptionType;
import eu.toop.regrep.slot.ISlotProvider;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.w3c.dom.Node;

public class EDMErrorResponse
implements IEDMTopLevelObject {
    private static final ICommonsOrderedSet<String> TOP_LEVEL_SLOTS = new CommonsLinkedHashSet<String>("SpecificationIdentifier", "ErrorProvider");
    private final ERegRepResponseStatus m_eResponseStatus;
    private final String m_sRequestID;
    private final String m_sSpecificationIdentifier;
    private final AgentPojo m_aErrorProvider;
    private final ICommonsList<EDMExceptionPojo> m_aExceptions = new CommonsArrayList<EDMExceptionPojo>();

    protected EDMErrorResponse(@Nonnull ERegRepResponseStatus eRegRepResponseStatus, @Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nullable AgentPojo agentPojo, @Nonnull @Nonempty ICommonsList<EDMExceptionPojo> iCommonsList) {
        ValueEnforcer.notNull(eRegRepResponseStatus, "ResponseStatus");
        ValueEnforcer.isTrue(eRegRepResponseStatus == ERegRepResponseStatus.SUCCESS || eRegRepResponseStatus == ERegRepResponseStatus.FAILURE, "Only SUCCESS and FAILURE are supported");
        ValueEnforcer.notEmpty(string, "RequestID");
        ValueEnforcer.notEmpty(string2, "SpecificationIdentifier");
        ValueEnforcer.notEmptyNoNullValue(iCommonsList, "Exceptions");
        this.m_eResponseStatus = eRegRepResponseStatus;
        this.m_sRequestID = string;
        this.m_sSpecificationIdentifier = string2;
        this.m_aErrorProvider = agentPojo;
        this.m_aExceptions.addAll(iCommonsList);
    }

    @Nonnull
    public final ERegRepResponseStatus getResponseStatus() {
        return this.m_eResponseStatus;
    }

    @Nonnull
    @Nonempty
    public final String getRequestID() {
        return this.m_sRequestID;
    }

    @Nonnull
    @Nonempty
    public final String getSpecificationIdentifier() {
        return this.m_sSpecificationIdentifier;
    }

    @Nullable
    public final AgentPojo getErrorProvider() {
        return this.m_aErrorProvider;
    }

    @Nonnull
    @Nonempty
    public final List<EDMExceptionPojo> exceptions() {
        return this.m_aExceptions;
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public final List<EDMExceptionPojo> getAllExceptions() {
        return (List)this.m_aExceptions.getClone();
    }

    @Nonnull
    private QueryResponse _createQueryResponse(@Nonnull ICommonsList<ISlotProvider> iCommonsList) {
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        for (ISlotProvider object : iCommonsList) {
            String string = object.getName();
            if (commonsLinkedHashMap.containsKey(string)) {
                throw new IllegalArgumentException("A slot provider for name '" + string + "' is already present");
            }
            commonsLinkedHashMap.put(string, object);
        }
        QueryResponse queryResponse = RegRepHelper.createEmptyQueryResponse(this.m_eResponseStatus);
        queryResponse.setRequestId(this.m_sRequestID);
        for (String string : TOP_LEVEL_SLOTS) {
            ISlotProvider iSlotProvider = (ISlotProvider)commonsLinkedHashMap.get(string);
            if (iSlotProvider == null) continue;
            queryResponse.addSlot(iSlotProvider.createSlot());
        }
        for (EDMExceptionPojo eDMExceptionPojo : this.m_aExceptions) {
            queryResponse.addException(eDMExceptionPojo.getAsRegistryException());
        }
        return queryResponse;
    }

    @Nonnull
    public QueryResponse getAsErrorResponse() {
        CommonsArrayList<ISlotProvider> commonsArrayList = new CommonsArrayList<ISlotProvider>();
        if (this.m_sSpecificationIdentifier != null) {
            commonsArrayList.add(new SlotSpecificationIdentifier(this.m_sSpecificationIdentifier));
        }
        if (this.m_aErrorProvider != null) {
            commonsArrayList.add(new SlotErrorProvider(this.m_aErrorProvider));
        }
        return this._createQueryResponse(commonsArrayList);
    }

    @Nonnull
    public IVersatileWriter<QueryResponse> getWriter() {
        return new JAXBVersatileWriter<QueryResponse>(this.getAsErrorResponse(), (IJAXBWriter<QueryResponse>)RegRep4Writer.queryResponse(CCCEV.XSDS).setFormattedOutput(true));
    }

    @Nonnull
    public static IJAXBVersatileReader<EDMErrorResponse> reader() {
        return new JAXBVersatileReader<QueryResponse, EDMErrorResponse>(RegRep4Reader.queryResponse(CCCEV.XSDS), EDMErrorResponse::create);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        EDMErrorResponse eDMErrorResponse = (EDMErrorResponse)object;
        return EqualsHelper.equals(this.m_eResponseStatus, eDMErrorResponse.m_eResponseStatus) && EqualsHelper.equals(this.m_sRequestID, eDMErrorResponse.m_sRequestID) && EqualsHelper.equals(this.m_sSpecificationIdentifier, eDMErrorResponse.m_sSpecificationIdentifier) && EqualsHelper.equals(this.m_aErrorProvider, eDMErrorResponse.m_aErrorProvider) && EqualsHelper.equals(this.m_aExceptions, eDMErrorResponse.m_aExceptions);
    }

    public int hashCode() {
        return ((HashCodeGenerator)((HashCodeGenerator)new HashCodeGenerator(this).append((Enum)this.m_eResponseStatus)).append(this.m_sRequestID).append(this.m_sSpecificationIdentifier).append(this.m_aErrorProvider).append(this.m_aExceptions)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("RequestID", this.m_sRequestID).append("ResponseStatus", this.m_eResponseStatus).append("SpecificationIdentifier", this.m_sSpecificationIdentifier).append("ErrorProvider", this.m_aErrorProvider).append("Exceptions", this.m_aExceptions).getToString();
    }

    @Nonnull
    public static Builder builder() {
        return new Builder().specificationIdentifier("toop-edm:v2.0").responseStatus(ERegRepResponseStatus.FAILURE);
    }

    private static void _applySlots(@Nonnull SlotType slotType, @Nonnull Builder builder) {
        String string = slotType.getName();
        ValueType valueType = slotType.getSlotValue();
        switch (string) {
            case "SpecificationIdentifier": {
                if (!(valueType instanceof StringValueType)) break;
                String string2 = ((StringValueType)valueType).getValue();
                builder.specificationIdentifier(string2);
                break;
            }
            case "ErrorProvider": {
                if (!(valueType instanceof AnyValueType)) break;
                Node node = (Node)((AnyValueType)valueType).getAny();
                builder.errorProvider(AgentPojo.builder((AgentType)new AgentMarshaller().read(node)));
                break;
            }
            default: {
                throw new IllegalStateException("Found unsupported slot '" + string + "'");
            }
        }
    }

    @Nonnull
    public static EDMErrorResponse create(@Nonnull QueryResponse queryResponse) {
        Builder builder = EDMErrorResponse.builder().responseStatus(ERegRepResponseStatus.getFromIDOrNull(queryResponse.getStatus())).requestID(queryResponse.getRequestId());
        for (SlotType extensibleObjectType : queryResponse.getSlot()) {
            EDMErrorResponse._applySlots(extensibleObjectType, builder);
        }
        for (RegistryExceptionType registryExceptionType : queryResponse.getException()) {
            builder.addException(registryExceptionType);
        }
        return builder.build();
    }

    public static class Builder {
        private ERegRepResponseStatus m_eResponseStatus;
        private String m_sRequestID;
        private String m_sSpecificationIdentifier;
        private AgentPojo m_aErrorProvider;
        private final ICommonsList<EDMExceptionPojo> m_aExceptions = new CommonsArrayList<EDMExceptionPojo>();

        @Nonnull
        public Builder responseStatus(@Nullable ERegRepResponseStatus eRegRepResponseStatus) {
            this.m_eResponseStatus = eRegRepResponseStatus;
            return this;
        }

        @Nonnull
        public Builder requestID(@Nullable String string) {
            this.m_sRequestID = string;
            return this;
        }

        @Nonnull
        public Builder specificationIdentifier(@Nullable String string) {
            this.m_sSpecificationIdentifier = string;
            return this;
        }

        @Nonnull
        public final Builder errorProvider(@Nullable Consumer<? super AgentPojo.Builder> consumer) {
            if (consumer != null) {
                AgentPojo.Builder builder = AgentPojo.builder();
                consumer.accept(builder);
                this.errorProvider(builder.build());
            }
            return this;
        }

        @Nonnull
        public Builder errorProvider(@Nullable AgentPojo.Builder builder) {
            return this.errorProvider(builder == null ? null : builder.build());
        }

        @Nonnull
        public Builder errorProvider(@Nullable AgentType agentType) {
            return this.errorProvider(agentType == null ? null : AgentPojo.builder(agentType));
        }

        @Nonnull
        public Builder errorProvider(@Nullable AgentPojo agentPojo) {
            this.m_aErrorProvider = agentPojo;
            return this;
        }

        @Nonnull
        public final Builder addException(@Nullable Consumer<? super EDMExceptionPojo.Builder> consumer) {
            if (consumer != null) {
                EDMExceptionPojo.Builder builder = EDMExceptionPojo.builder();
                consumer.accept(builder);
                this.addException(builder.build());
            }
            return this;
        }

        @Nonnull
        public Builder addException(@Nullable RegistryExceptionType registryExceptionType) {
            return this.addException(registryExceptionType == null ? null : EDMExceptionPojo.builder(registryExceptionType));
        }

        @Nonnull
        public Builder addException(@Nullable EDMExceptionPojo.Builder builder) {
            return this.addException(builder == null ? null : builder.build());
        }

        @Nonnull
        public Builder addException(@Nullable EDMExceptionPojo eDMExceptionPojo) {
            if (eDMExceptionPojo != null) {
                this.m_aExceptions.add(eDMExceptionPojo);
            }
            return this;
        }

        @Nonnull
        public final Builder exception(@Nullable Consumer<? super EDMExceptionPojo.Builder> consumer) {
            if (consumer != null) {
                EDMExceptionPojo.Builder builder = EDMExceptionPojo.builder();
                consumer.accept(builder);
                this.exception(builder.build());
            }
            return this;
        }

        @Nonnull
        public Builder exception(@Nullable EDMExceptionPojo.Builder builder) {
            return this.exception(builder == null ? null : builder.build());
        }

        @Nonnull
        public Builder exception(@Nullable RegistryExceptionType registryExceptionType) {
            return this.exception(registryExceptionType == null ? null : EDMExceptionPojo.builder(registryExceptionType));
        }

        @Nonnull
        public Builder exception(@Nullable EDMExceptionPojo eDMExceptionPojo) {
            if (eDMExceptionPojo != null) {
                this.m_aExceptions.set(eDMExceptionPojo);
            } else {
                this.m_aExceptions.clear();
            }
            return this;
        }

        @Nonnull
        public Builder exceptions(EDMExceptionPojo ... eDMExceptionPojoArray) {
            this.m_aExceptions.setAll((EDMExceptionPojo[])eDMExceptionPojoArray);
            return this;
        }

        @Nonnull
        public Builder exceptions(@Nullable Iterable<? extends EDMExceptionPojo> iterable) {
            this.m_aExceptions.setAll(iterable);
            return this;
        }

        @Nonnull
        public <T> Builder exceptions(@Nullable Iterable<? extends T> iterable, @Nonnull Function<? super T, EDMExceptionPojo> function) {
            this.m_aExceptions.setAllMapped(iterable, function);
            return this;
        }

        public void checkConsistency() {
            if (this.m_eResponseStatus == null) {
                throw new IllegalStateException("Response Status must be present");
            }
            if (this.m_eResponseStatus != ERegRepResponseStatus.SUCCESS && this.m_eResponseStatus != ERegRepResponseStatus.FAILURE) {
                throw new IllegalStateException("Response Status must be SUCCESS or FAILURE");
            }
            if (StringHelper.hasNoText(this.m_sRequestID)) {
                throw new IllegalStateException("Request ID must be present");
            }
            if (StringHelper.hasNoText(this.m_sSpecificationIdentifier)) {
                throw new IllegalStateException("SpecificationIdentifier must be present");
            }
            if (this.m_aExceptions.isEmpty()) {
                throw new IllegalStateException("At least one Exception must be present");
            }
        }

        @Nonnull
        public EDMErrorResponse build() {
            this.checkConsistency();
            return new EDMErrorResponse(this.m_eResponseStatus, this.m_sRequestID, this.m_sSpecificationIdentifier, this.m_aErrorProvider, this.m_aExceptions);
        }
    }
}

