/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.dsd.api;

import com.helger.pd.searchapi.v1.MatchType;
import eu.toop.dsd.api.DSDTypesManipulator;
import eu.toop.edm.xml.IJAXBVersatileReader;
import eu.toop.edm.xml.cagv.CCAGV;
import eu.toop.regrep.RegRep4Reader;
import eu.toop.regrep.query.QueryResponse;
import eu.toop.regrep.rim.AnyValueType;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.transform.Source;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class MatchTypeListReader
implements IJAXBVersatileReader<List<MatchType>> {
    public static final String DATASET_SLOT_NAME = "Dataset";

    MatchTypeListReader() {
    }

    @Override
    @Nullable
    public List<MatchType> read(@Nonnull Source source) {
        QueryResponse queryResponse = (QueryResponse)RegRep4Reader.queryResponse(CCAGV.XSDS).read(source);
        if (queryResponse == null) {
            return null;
        }
        return MatchTypeListReader.convertQueryResponseToMatchTypeList(queryResponse);
    }

    @Override
    @Nullable
    public List<MatchType> read(@Nonnull Node node) {
        QueryResponse queryResponse = (QueryResponse)RegRep4Reader.queryResponse(CCAGV.XSDS).read(node);
        if (queryResponse == null) {
            return null;
        }
        return MatchTypeListReader.convertQueryResponseToMatchTypeList(queryResponse);
    }

    private static List<MatchType> convertQueryResponseToMatchTypeList(QueryResponse queryResponse) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        queryResponse.getRegistryObjectList().getRegistryObject().forEach(registryObjectType -> registryObjectType.getSlot().forEach(slotType -> {
            if (DATASET_SLOT_NAME.equals(slotType.getName())) {
                Element element = (Element)((AnyValueType)slotType.getSlotValue()).getAny();
                arrayList.add(element);
            }
        }));
        return DSDTypesManipulator.convertDCatElementsToMatchTypes(DSDTypesManipulator.convertElementsToDCatList(arrayList));
    }
}

