/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.dsd.api;

import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.pd.searchapi.v1.EntityType;
import com.helger.pd.searchapi.v1.MatchType;
import com.helger.pd.searchapi.v1.NameType;
import com.helger.peppolid.CIdentifier;
import eu.toop.dsd.api.types.DoctypeFormatException;
import eu.toop.dsd.api.types.DoctypeParts;
import eu.toop.edm.jaxb.cv.agent.LocationType;
import eu.toop.edm.jaxb.cv.agent.PublicOrganizationType;
import eu.toop.edm.jaxb.cv.cbc.IDType;
import eu.toop.edm.jaxb.dcatap.DCatAPDataServiceType;
import eu.toop.edm.jaxb.dcatap.DCatAPDatasetType;
import eu.toop.edm.jaxb.dcatap.DCatAPDistributionType;
import eu.toop.edm.jaxb.dcterms.DCMediaType;
import eu.toop.edm.jaxb.dcterms.DCStandardType;
import eu.toop.edm.jaxb.w3.locn.AddressType;
import eu.toop.edm.xml.dcatap.DatasetMarshaller;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DSDTypesManipulator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DSDTypesManipulator.class);

    public static List<Document> convertMatchTypesToDCATDocuments(String string, List<MatchType> list) {
        LOGGER.debug("DatasetType: " + string);
        ArrayList<Document> arrayList = new ArrayList<Document>(list.size());
        list.forEach(matchType -> matchType.getDocTypeID().forEach(iDType -> {
            if (matchType.getDocTypeID().size() > 0 && matchType.getEntity().size() > 0) {
                DatasetMarshaller datasetMarshaller = new DatasetMarshaller();
                DCatAPDatasetType dCatAPDatasetType = new DCatAPDatasetType();
                String string2 = DSDTypesManipulator.flattenIdType(iDType);
                DoctypeParts doctypeParts = DoctypeParts.parse(string2);
                DSDTypesManipulator.setConformsTo(dCatAPDatasetType, "?" + string + "_ONTOLOGY_URI?");
                dCatAPDatasetType.addIdentifier(doctypeParts.getDataSetIdentifier());
                dCatAPDatasetType.setType(string);
                dCatAPDatasetType.addTitle("?" + string + " dataset?");
                dCatAPDatasetType.addDescription("?A dataset for " + string + "?");
                DSDTypesManipulator.addPublishers(matchType, dCatAPDatasetType);
                DSDTypesManipulator.addDistribution(iDType, dCatAPDatasetType, string, doctypeParts);
                Document document = datasetMarshaller.getAsDocument(dCatAPDatasetType);
                arrayList.add(document);
            }
        }));
        return arrayList;
    }

    private static void addDistribution(com.helger.pd.searchapi.v1.IDType iDType, DCatAPDatasetType dCatAPDatasetType, String string, DoctypeParts doctypeParts) {
        IExplicitlyCloneable iExplicitlyCloneable;
        DCatAPDistributionType dCatAPDistributionType = new DCatAPDistributionType();
        dCatAPDistributionType.setAccessURL("");
        if (doctypeParts.getDistributionConformsTo() != null) {
            iExplicitlyCloneable = new DCStandardType();
            ((DCStandardType)iExplicitlyCloneable).setValue(doctypeParts.getDistributionConformsTo());
            dCatAPDistributionType.addConformsTo((DCStandardType)iExplicitlyCloneable);
        }
        iExplicitlyCloneable = new DCMediaType();
        ((DCMediaType)iExplicitlyCloneable).addContent(doctypeParts.getDistributionFormat());
        dCatAPDistributionType.setFormat((DCMediaType)iExplicitlyCloneable);
        dCatAPDistributionType.addDescription("?This is a distribution of " + string + "?");
        DCatAPDataServiceType dCatAPDataServiceType = new DCatAPDataServiceType();
        dCatAPDataServiceType.setIdentifier(DSDTypesManipulator.flattenIdType(iDType));
        dCatAPDataServiceType.setTitle("?Service for " + string + " distribution?");
        dCatAPDataServiceType.addEndpointURL("");
        dCatAPDataServiceType.addConformsTo(new DCStandardType(doctypeParts.getConformsTo()));
        dCatAPDistributionType.setAccessService(dCatAPDataServiceType);
        DCMediaType dCMediaType = new DCMediaType();
        dCMediaType.addContent("?application/xml?");
        dCatAPDistributionType.setMediaType(dCMediaType);
        dCatAPDatasetType.addDistribution(dCatAPDistributionType);
    }

    private static void setConformsTo(DCatAPDatasetType dCatAPDatasetType, String string) {
        DCStandardType dCStandardType = new DCStandardType();
        dCStandardType.setValue(string);
        dCatAPDatasetType.addConformsTo(dCStandardType);
    }

    private static void addPublishers(MatchType matchType, DCatAPDatasetType dCatAPDatasetType) {
        matchType.getEntity().forEach(entityType -> {
            PublicOrganizationType publicOrganizationType = new PublicOrganizationType();
            IDType iDType = new IDType();
            iDType.setSchemeName(matchType.getParticipantID().getScheme());
            iDType.setValue(matchType.getParticipantIDValue());
            publicOrganizationType.addId(iDType);
            AddressType addressType = new AddressType();
            addressType.setAdminUnitLevel1(entityType.getCountryCode());
            addressType.setFullAddress(entityType.getGeoInfo());
            LocationType locationType = new LocationType();
            locationType.setAddress(addressType);
            publicOrganizationType.addLocation(locationType);
            List<NameType> list = entityType.getName();
            list.forEach(nameType -> publicOrganizationType.getPrefLabel().add(nameType.getValue()));
            dCatAPDatasetType.addPublisher(publicOrganizationType);
        });
    }

    public static String flattenIdType(com.helger.pd.searchapi.v1.IDType iDType) {
        return CIdentifier.getURIEncoded(iDType.getScheme(), iDType.getValue());
    }

    public static List<DCatAPDatasetType> convertElementsToDCatList(List<Element> list) {
        ArrayList<DCatAPDatasetType> arrayList = new ArrayList<DCatAPDatasetType>(list.size());
        DatasetMarshaller datasetMarshaller = new DatasetMarshaller();
        list.forEach(element -> {
            DCatAPDatasetType dCatAPDatasetType = (DCatAPDatasetType)datasetMarshaller.read((Node)element);
            arrayList.add(dCatAPDatasetType);
        });
        return arrayList;
    }

    public static List<MatchType> convertDCatElementsToMatchTypes(List<DCatAPDatasetType> list) {
        ArrayList<MatchType> arrayList = new ArrayList<MatchType>(list.size());
        list.forEach(dCatAPDatasetType -> {
            MatchType matchType = new MatchType();
            arrayList.add(matchType);
            dCatAPDatasetType.getPublisher().forEach(foafAgentType -> {
                PublicOrganizationType publicOrganizationType = (PublicOrganizationType)foafAgentType;
                com.helger.pd.searchapi.v1.IDType iDType = new com.helger.pd.searchapi.v1.IDType();
                IDType iDType2 = publicOrganizationType.getIdAtIndex(0);
                iDType.setScheme(iDType2.getSchemeName());
                iDType.setValue(iDType2.getValue());
                matchType.setParticipantID(iDType);
                EntityType entityType = new EntityType();
                AddressType addressType = publicOrganizationType.getLocationAtIndex(0).getAddress();
                entityType.setCountryCode(addressType.getAdminUnitLevel1());
                entityType.setGeoInfo(addressType.getFullAddress());
                publicOrganizationType.getPrefLabel().forEach(string -> entityType.addName(new NameType((String)string)));
                matchType.addEntity(entityType);
            });
            dCatAPDatasetType.getDistribution().forEach(dCatAPDistributionType -> {
                com.helger.pd.searchapi.v1.IDType iDType = new com.helger.pd.searchapi.v1.IDType();
                String string = dCatAPDistributionType.getAccessService().getIdentifier();
                int n = string.indexOf("::");
                iDType.setScheme(string.substring(0, n));
                iDType.setValue(string.substring(n + 2));
                matchType.addDocTypeID(iDType);
            });
        });
        return arrayList;
    }

    public static void filterDirectoryResults(String string, String string2, List<MatchType> list) {
        Iterator<MatchType> iterator2 = list.iterator();
        while (iterator2.hasNext()) {
            Object object;
            Object object2;
            Object object3;
            MatchType matchType = iterator2.next();
            Iterator<com.helger.pd.searchapi.v1.IDType> iterator3 = matchType.getDocTypeID().iterator();
            while (iterator3.hasNext()) {
                object3 = iterator3.next();
                object2 = DSDTypesManipulator.flattenIdType((com.helger.pd.searchapi.v1.IDType)object3);
                try {
                    object = DoctypeParts.parse((String)object2);
                    if (((DoctypeParts)object).matches(string)) continue;
                    iterator3.remove();
                }
                catch (DoctypeFormatException doctypeFormatException) {
                    LOGGER.warn("Skipping doctype: " + (String)object2);
                    iterator3.remove();
                }
            }
            if (matchType.getDocTypeID().size() == 0) {
                iterator2.remove();
                continue;
            }
            if (string2 == null) continue;
            object3 = matchType.getEntity();
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (EntityType)object2.next();
                if (((EntityType)object).getCountryCode().equals(string2)) continue;
                object2.remove();
            }
            if (!matchType.getEntity().isEmpty()) continue;
            iterator2.remove();
        }
    }
}

