/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.app.incoming;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.state.ESuccess;
import com.helger.commons.string.StringHelper;
import com.helger.commons.url.IURLProtocol;
import com.helger.commons.url.URLProtocolRegistry;
import com.helger.httpclient.HttpClientManager;
import com.helger.httpclient.response.ResponseHandlerByteArray;
import eu.toop.connector.api.TCConfig;
import eu.toop.connector.api.http.TCHttpClientSettings;
import eu.toop.connector.api.me.incoming.IMEIncomingTransportMetadata;
import eu.toop.connector.api.me.incoming.IncomingEDMErrorResponse;
import eu.toop.connector.api.me.incoming.IncomingEDMRequest;
import eu.toop.connector.api.me.incoming.IncomingEDMResponse;
import eu.toop.connector.api.me.model.MEPayload;
import eu.toop.connector.api.rest.TCIncomingMessage;
import eu.toop.connector.api.rest.TCIncomingMetadata;
import eu.toop.connector.api.rest.TCPayload;
import eu.toop.connector.api.rest.TCPayloadType;
import eu.toop.connector.api.rest.TCRestJAXB;
import eu.toop.kafkaclient.ToopKafkaClient;
import eu.toop.regrep.CRegRep4;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;

@Immutable
public final class MPTrigger {
    private MPTrigger() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    private static ESuccess _forwardMessage(@Nonnull TCIncomingMessage tCIncomingMessage, @Nonnull @Nonempty String string) {
        ValueEnforcer.notNull(tCIncomingMessage, "Msg");
        ValueEnforcer.notEmpty(string, "Destination URL");
        if (StringHelper.hasNoText(string)) {
            throw new IllegalStateException("No URL for handling inbound messages is defined.");
        }
        IURLProtocol iURLProtocol = URLProtocolRegistry.getInstance().getProtocol(string);
        if (iURLProtocol == null) {
            throw new IllegalStateException("The URL for handling inbound messages '" + string + "' is invalid.");
        }
        byte[] byArray = TCRestJAXB.incomingMessage().getAsBytes(tCIncomingMessage);
        if (byArray == null) {
            throw new IllegalStateException();
        }
        ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> "Sending inbound message to '" + string + "' with " + byArray.length + " bytes");
        try (HttpClientManager httpClientManager = HttpClientManager.create(new TCHttpClientSettings());){
            HttpPost httpPost = new HttpPost(string);
            httpPost.setEntity(new ByteArrayEntity(byArray));
            byte[] byArray2 = httpClientManager.execute((HttpUriRequest)httpPost, new ResponseHandlerByteArray());
            ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> "Sending inbound message was successful. Got " + ArrayHelper.getSize(byArray2) + " bytes back");
            ESuccess eSuccess = ESuccess.SUCCESS;
            return eSuccess;
        }
        catch (Exception exception) {
            ToopKafkaClient.send(EErrorLevel.ERROR, () -> "Sending inbound message to '" + string + "' failed", exception);
            return ESuccess.FAILURE;
        }
    }

    @Nonnull
    private static TCIncomingMetadata _createMetadata(@Nonnull IMEIncomingTransportMetadata iMEIncomingTransportMetadata, @Nonnull TCPayloadType tCPayloadType) {
        TCIncomingMetadata tCIncomingMetadata = new TCIncomingMetadata();
        tCIncomingMetadata.setSenderID(TCRestJAXB.createTCID(iMEIncomingTransportMetadata.getSenderID()));
        tCIncomingMetadata.setReceiverID(TCRestJAXB.createTCID(iMEIncomingTransportMetadata.getReceiverID()));
        tCIncomingMetadata.setDocTypeID(TCRestJAXB.createTCID(iMEIncomingTransportMetadata.getDocumentTypeID()));
        tCIncomingMetadata.setProcessID(TCRestJAXB.createTCID(iMEIncomingTransportMetadata.getProcessID()));
        tCIncomingMetadata.setPayloadType(tCPayloadType);
        return tCIncomingMetadata;
    }

    @Nonnull
    private static TCPayload _createPayload(@Nonnull byte[] byArray, @Nullable String string, @Nonnull IMimeType iMimeType) {
        TCPayload tCPayload = new TCPayload();
        tCPayload.setValue(byArray);
        tCPayload.setContentID(string);
        tCPayload.setMimeType(iMimeType.getAsString());
        return tCPayload;
    }

    @Nonnull
    @Nonempty
    private static String _getConfiguredDestURL() {
        String string = TCConfig.MEM.getMEMIncomingURL();
        if (StringHelper.hasNoText(string)) {
            throw new IllegalStateException("The MEM incoming URL for forwarding to DC/DP is not configured.");
        }
        return string;
    }

    @Nonnull
    public static ESuccess forwardMessage(@Nonnull IncomingEDMRequest incomingEDMRequest) {
        return MPTrigger.forwardMessage(incomingEDMRequest, MPTrigger._getConfiguredDestURL());
    }

    @Nonnull
    public static ESuccess forwardMessage(@Nonnull IncomingEDMRequest incomingEDMRequest, @Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Destination URL");
        TCIncomingMessage tCIncomingMessage = new TCIncomingMessage();
        tCIncomingMessage.setMetadata(MPTrigger._createMetadata(incomingEDMRequest.getMetadata(), TCPayloadType.REQUEST));
        tCIncomingMessage.addPayload(MPTrigger._createPayload(incomingEDMRequest.getRequest().getWriter().getAsBytes(), incomingEDMRequest.getTopLevelContentID(), CRegRep4.MIME_TYPE_EBRS_XML));
        return MPTrigger._forwardMessage(tCIncomingMessage, string);
    }

    @Nonnull
    public static ESuccess forwardMessage(@Nonnull IncomingEDMResponse incomingEDMResponse) {
        return MPTrigger.forwardMessage(incomingEDMResponse, MPTrigger._getConfiguredDestURL());
    }

    @Nonnull
    public static ESuccess forwardMessage(@Nonnull IncomingEDMResponse incomingEDMResponse, @Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Destination URL");
        TCIncomingMessage tCIncomingMessage = new TCIncomingMessage();
        tCIncomingMessage.setMetadata(MPTrigger._createMetadata(incomingEDMResponse.getMetadata(), TCPayloadType.RESPONSE));
        tCIncomingMessage.addPayload(MPTrigger._createPayload(incomingEDMResponse.getResponse().getWriter().getAsBytes(), incomingEDMResponse.getTopLevelContentID(), CRegRep4.MIME_TYPE_EBRS_XML));
        for (MEPayload mEPayload : incomingEDMResponse.attachments().values()) {
            tCIncomingMessage.addPayload(MPTrigger._createPayload(mEPayload.getData().bytes(), mEPayload.getContentID(), mEPayload.getMimeType()));
        }
        return MPTrigger._forwardMessage(tCIncomingMessage, string);
    }

    @Nonnull
    public static ESuccess forwardMessage(@Nonnull IncomingEDMErrorResponse incomingEDMErrorResponse) {
        return MPTrigger.forwardMessage(incomingEDMErrorResponse, MPTrigger._getConfiguredDestURL());
    }

    @Nonnull
    public static ESuccess forwardMessage(@Nonnull IncomingEDMErrorResponse incomingEDMErrorResponse, @Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Destination URL");
        TCIncomingMessage tCIncomingMessage = new TCIncomingMessage();
        tCIncomingMessage.setMetadata(MPTrigger._createMetadata(incomingEDMErrorResponse.getMetadata(), TCPayloadType.ERROR_RESPONSE));
        tCIncomingMessage.addPayload(MPTrigger._createPayload(incomingEDMErrorResponse.getErrorResponse().getWriter().getAsBytes(), incomingEDMErrorResponse.getTopLevelContentID(), CRegRep4.MIME_TYPE_EBRS_XML));
        return MPTrigger._forwardMessage(tCIncomingMessage, string);
    }
}

