/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.app;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.datetime.PDTWebDateHelper;
import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.system.SystemProperties;
import com.helger.config.source.res.IConfigurationSourceResource;
import com.helger.json.IJsonObject;
import com.helger.json.JsonObject;
import eu.toop.connector.api.TCConfig;
import eu.toop.connector.app.CTC;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TCStatusHelper {
    private TCStatusHelper() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static IJsonObject getDefaultStatusData() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("status.datetime", PDTWebDateHelper.getAsStringXSD(PDTFactory.getCurrentZonedDateTimeUTC()));
        jsonObject.add("version.toop-connector", CTC.getVersionNumber());
        jsonObject.add("version.build-datetime", CTC.getBuildTimestamp());
        jsonObject.add("version.java", SystemProperties.getJavaVersion());
        jsonObject.add("global.debug", GlobalDebug.isDebugMode());
        jsonObject.add("global.production", GlobalDebug.isProductionMode());
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        TCConfig.getConfig().forEachConfigurationValueProvider((iConfigurationValueProvider, n) -> {
            if (iConfigurationValueProvider instanceof IConfigurationSourceResource) {
                ICommonsOrderedMap<String, String> iCommonsOrderedMap2 = ((IConfigurationSourceResource)iConfigurationValueProvider).getAllConfigItems();
                for (Map.Entry entry : iCommonsOrderedMap2.entrySet()) {
                    if (commonsLinkedHashMap.containsKey(entry.getKey())) continue;
                    commonsLinkedHashMap.put(entry);
                }
            }
        });
        for (Map.Entry entry : commonsLinkedHashMap.entrySet()) {
            String string = (String)entry.getKey();
            if (string.contains("password")) {
                jsonObject.add((String)entry.getKey(), "***");
                continue;
            }
            jsonObject.add((String)entry.getKey(), entry.getValue());
        }
        return jsonObject;
    }
}

