/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.api;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.id.factory.GlobalIDFactory;
import com.helger.commons.url.URLHelper;
import com.helger.config.Config;
import com.helger.config.ConfigFactory;
import com.helger.config.IConfig;
import com.helger.config.source.MultiConfigurationValueProvider;
import com.helger.peppol.sml.ESML;
import com.helger.peppol.sml.ISMLInfo;
import com.helger.peppol.sml.SMLInfo;
import com.helger.peppolid.factory.IIdentifierFactory;
import eu.toop.connector.api.TCIdentifierFactory;
import eu.toop.connector.api.me.EMEProtocol;
import java.net.URI;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class TCConfig {
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static IConfig s_aConfig;

    private TCConfig() {
    }

    @Nonnull
    public static IConfig getConfig() {
        return s_aRWLock.readLockedGet(() -> s_aConfig);
    }

    public static void setConfig(@Nonnull IConfig iConfig) {
        ValueEnforcer.notNull(iConfig, "Config");
        s_aRWLock.writeLockedGet(() -> {
            s_aConfig = iConfig;
            return s_aConfig;
        });
    }

    public static void setDefaultConfig() {
        MultiConfigurationValueProvider multiConfigurationValueProvider = ConfigFactory.createDefaultValueProvider();
        Config config = Config.create(multiConfigurationValueProvider);
        TCConfig.setConfig(config);
    }

    @Nonnull
    public static IIdentifierFactory getIdentifierFactory() {
        return TCIdentifierFactory.INSTANCE_TC;
    }

    static {
        TCConfig.setDefaultConfig();
    }

    public static class WebApp {
        private WebApp() {
        }

        public static boolean isStatusEnabled() {
            return TCConfig.getConfig().getAsBoolean("toop.webapp.status.enabled", true);
        }
    }

    public static class HTTP {
        private HTTP() {
        }

        public static boolean isProxyServerEnabled() {
            return TCConfig.getConfig().getAsBoolean("http.proxy.enabled", false);
        }

        @Nullable
        public static String getProxyServerAddress() {
            return TCConfig.getConfig().getAsString("http.proxy.address");
        }

        @CheckForSigned
        public static int getProxyServerPort() {
            return TCConfig.getConfig().getAsInt("http.proxy.port", -1);
        }

        @Nullable
        public static String getProxyServerNonProxyHosts() {
            return TCConfig.getConfig().getAsString("http.proxy.non-proxy");
        }

        public static boolean isTLSTrustAll() {
            return TCConfig.getConfig().getAsBoolean("http.tls.trustall", false);
        }

        public static int getConnectionTimeoutMS() {
            return TCConfig.getConfig().getAsInt("http.connection-timeout", -1);
        }

        public static int getReadTimeoutMS() {
            return TCConfig.getConfig().getAsInt("http.read-timeout", -1);
        }
    }

    public static class MEM {
        private MEM() {
        }

        @Nullable
        public static String getMEMImplementationID() {
            return TCConfig.getConfig().getAsString("toop.mem.implementation");
        }

        @Nonnull
        public static EMEProtocol getMEMProtocol() {
            String string = TCConfig.getConfig().getAsString("toop.mem.protocol", EMEProtocol.DEFAULT.getID());
            EMEProtocol eMEProtocol = EMEProtocol.getFromIDOrNull(string);
            if (eMEProtocol == null) {
                throw new IllegalStateException("Failed to resolve protocol with ID '" + string + "'");
            }
            return eMEProtocol;
        }

        @Nullable
        public static String getMEMAS4Endpoint() {
            return TCConfig.getConfig().getAsString("toop.mem.as4.endpoint");
        }

        @Nullable
        public static String getMEMAS4GwPartyID() {
            return TCConfig.getConfig().getAsString("toop.mem.as4.gw.partyid");
        }

        @Nullable
        public static String getMEMAS4TcPartyid() {
            return TCConfig.getConfig().getAsString("toop.mem.as4.tc.partyid");
        }

        public static long getGatewayNotificationWaitTimeout() {
            return TCConfig.getConfig().getAsLong("toop.mem.as4.notificationWaitTimeout", 20000L);
        }

        @Nullable
        public static String getMEMIncomingURL() {
            return TCConfig.getConfig().getAsString("toop.mem.incoming.url");
        }

        public static boolean isMEMOutgoingDumpEnabled() {
            return TCConfig.getConfig().getAsBoolean("toop.mem.outgoing.dump.enabled", false);
        }

        @Nullable
        public static String getMEMOutgoingDumpPath() {
            return TCConfig.getConfig().getAsString("toop.mem.outgoing.dump.path");
        }

        public static boolean isMEMIncomingDumpEnabled() {
            return TCConfig.getConfig().getAsBoolean("toop.mem.incoming.dump.enabled", false);
        }

        @Nullable
        public static String getMEMIncomingDumpPath() {
            return TCConfig.getConfig().getAsString("toop.mem.incoming.dump.path");
        }
    }

    public static class R2D2 {
        public static final boolean DEFAULT_USE_SML = true;
        private static ISMLInfo s_aCachedSMLInfo;

        private R2D2() {
        }

        public static boolean isR2D2UseDNS() {
            return TCConfig.getConfig().getAsBoolean("toop.r2d2.usedns", true);
        }

        @Nonnull
        public static ISMLInfo getR2D2SML() {
            ISMLInfo iSMLInfo = s_aCachedSMLInfo;
            if (iSMLInfo == null) {
                String string = TCConfig.getConfig().getAsString("toop.r2d2.sml.id");
                ESML eSML = ESML.getFromIDOrNull(string);
                if (eSML != null) {
                    iSMLInfo = eSML;
                } else {
                    String string2 = TCConfig.getConfig().getAsString("toop.r2d2.sml.name", "TOOP SML");
                    String string3 = TCConfig.getConfig().getAsString("toop.r2d2.sml.dnszone");
                    String string4 = TCConfig.getConfig().getAsString("toop.r2d2.sml.serviceurl");
                    boolean bl = TCConfig.getConfig().getAsBoolean("toop.r2d2.sml.clientcert", false);
                    iSMLInfo = new SMLInfo(GlobalIDFactory.getNewStringID(), string2, string3, string4, bl);
                }
                s_aCachedSMLInfo = iSMLInfo;
            }
            return iSMLInfo;
        }

        @Nullable
        public static URI getR2D2SMPUrl() {
            String string = TCConfig.getConfig().getAsString("toop.r2d2.smp.url");
            return URLHelper.getAsURI(string);
        }
    }

    public static class DSD {
        private DSD() {
        }

        @Nullable
        public static String getDSDBaseUrl() {
            return TCConfig.getConfig().getAsString("toop.dsd.service.baseurl");
        }
    }

    public static class Tracker {
        public static final boolean DEFAULT_TOOP_TRACKER_ENABLED = false;
        public static final String DEFAULT_TOOP_TRACKER_TOPIC = "toop";

        private Tracker() {
        }

        public static boolean isToopTrackerEnabled() {
            return TCConfig.getConfig().getAsBoolean("toop.tracker.enabled", false);
        }

        @Nullable
        public static String getToopTrackerUrl() {
            return TCConfig.getConfig().getAsString("toop.tracker.url");
        }

        @Nullable
        public static String getToopTrackerTopic() {
            return TCConfig.getConfig().getAsString("toop.tracker.topic", DEFAULT_TOOP_TRACKER_TOPIC);
        }
    }

    public static class Global {
        private Global() {
        }

        public static boolean isGlobalDebug() {
            return TCConfig.getConfig().getAsBoolean("global.debug", GlobalDebug.isDebugMode());
        }

        public static boolean isGlobalProduction() {
            return TCConfig.getConfig().getAsBoolean("global.production", GlobalDebug.isProductionMode());
        }

        @Nullable
        public static String getToopInstanceName() {
            return TCConfig.getConfig().getAsString("global.instancename");
        }
    }
}

