/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.commons.codelist;

import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.string.StringHelper;
import com.helger.commons.version.Version;
import com.helger.peppolid.IProcessIdentifier;
import eu.toop.commons.codelist.IPredefined;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@CodingStyleguideUnaware
public enum EPredefinedProcessIdentifier implements IProcessIdentifier,
IPredefined
{
    URN_EU_TOOP_PROCESS_DATAREQUESTRESPONSE("TOOP Request Response for Data", "urn:eu.toop.process.datarequestresponse", Version.parse("1"), false, null),
    URN_EU_TOOP_PROCESS_DOCUMENTREQUESTRESPONSE("TOOP Request Response for Documents", "urn:eu.toop.process.documentrequestresponse", Version.parse("1"), false, null),
    URN_EU_TOOP_PROCESS_TWOPHASEDREQUESTRESPONSE("TOOP Two Phased Request Response for Documents", "urn:eu.toop.process.twophasedrequestresponse", Version.parse("2"), false, null),
    URN_EU_TOOP_PROCESS_DATAQUERY("TOOP DataQuery", "urn:eu.toop.process.dataquery", Version.parse("3"), false, null),
    URN_EU_TOOP_PROCESS_DOCUMENTQUERY("TOOP DocumentQuery", "urn:eu.toop.process.documentquery", Version.parse("3"), false, null),
    URN_EU_TOOP_PROCESS_DOCUMENTREFERENCEQUERY("TOOP DocumentReferenceQuery", "urn:eu.toop.process.documentreferencequery", Version.parse("3"), false, null);

    public static final EPredefinedProcessIdentifier DATAREQUESTRESPONSE;
    public static final EPredefinedProcessIdentifier DOCUMENTREQUESTRESPONSE;
    public static final EPredefinedProcessIdentifier TWOPHASEDREQUESTRESPONSE;
    public static final EPredefinedProcessIdentifier DATAQUERY;
    public static final EPredefinedProcessIdentifier DOCUMENTQUERY;
    public static final EPredefinedProcessIdentifier DOCUMENTREFERENCEQUERY;
    public static final String PROCESS_SCHEME = "toop-procid-agreement";
    private final String m_sName;
    private final String m_sID;
    private final Version m_aSince;
    private final boolean m_bDeprecated;
    private final Version m_aDeprecatedSince;

    private EPredefinedProcessIdentifier(@Nonnull String string2, String string3, @Nullable Version version, boolean bl, Version version2) {
        this.m_sName = string2;
        this.m_sID = string3;
        this.m_aSince = version;
        this.m_bDeprecated = bl;
        this.m_aDeprecatedSince = version2;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getName() {
        return this.m_sName;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getScheme() {
        return PROCESS_SCHEME;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getValue() {
        return this.m_sID;
    }

    @Override
    @Nonnull
    public Version getSince() {
        return this.m_aSince;
    }

    @Override
    public boolean isDeprecated() {
        return this.m_bDeprecated;
    }

    @Override
    @Nullable
    public Version getDeprecatedSince() {
        return this.m_aDeprecatedSince;
    }

    @Nullable
    public static EPredefinedProcessIdentifier getFromProcessIdentifierOrNull(@Nullable String string) {
        if (StringHelper.hasText(string)) {
            for (EPredefinedProcessIdentifier ePredefinedProcessIdentifier : EPredefinedProcessIdentifier.values()) {
                if (!ePredefinedProcessIdentifier.getID().equals(string)) continue;
                return ePredefinedProcessIdentifier;
            }
        }
        return null;
    }

    @Nullable
    public static EPredefinedProcessIdentifier getFromProcessIdentifierOrNull(@Nullable String string, @Nullable String string2) {
        if (StringHelper.hasText(string) && StringHelper.hasText(string2)) {
            for (EPredefinedProcessIdentifier ePredefinedProcessIdentifier : EPredefinedProcessIdentifier.values()) {
                if (!ePredefinedProcessIdentifier.getScheme().equals(string) || !ePredefinedProcessIdentifier.getID().equals(string2)) continue;
                return ePredefinedProcessIdentifier;
            }
        }
        return null;
    }

    static {
        DATAREQUESTRESPONSE = URN_EU_TOOP_PROCESS_DATAREQUESTRESPONSE;
        DOCUMENTREQUESTRESPONSE = URN_EU_TOOP_PROCESS_DOCUMENTREQUESTRESPONSE;
        TWOPHASEDREQUESTRESPONSE = URN_EU_TOOP_PROCESS_TWOPHASEDREQUESTRESPONSE;
        DATAQUERY = URN_EU_TOOP_PROCESS_DATAQUERY;
        DOCUMENTQUERY = URN_EU_TOOP_PROCESS_DOCUMENTQUERY;
        DOCUMENTREFERENCEQUERY = URN_EU_TOOP_PROCESS_DOCUMENTREFERENCEQUERY;
    }
}

