/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.util;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.Component;
import com.sun.xml.ws.api.ComponentEx;
import com.sun.xml.ws.api.server.ContainerResolver;
import com.sun.xml.ws.util.ServiceConfigurationError;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;

public final class ServiceFinder<T>
implements Iterable<T> {
    private static final String prefix = "META-INF/services/";
    private static WeakHashMap<ClassLoader, ConcurrentHashMap<String, ServiceName[]>> serviceNameCache = new WeakHashMap();
    private final Class<T> serviceClass;
    @Nullable
    private final ClassLoader classLoader;
    @Nullable
    private final ComponentEx component;

    public static <T> ServiceFinder<T> find(@NotNull Class<T> service2, @Nullable ClassLoader loader, Component component) {
        return new ServiceFinder<T>(service2, loader, component);
    }

    public static <T> ServiceFinder<T> find(@NotNull Class<T> service2, Component component) {
        return ServiceFinder.find(service2, Thread.currentThread().getContextClassLoader(), component);
    }

    public static <T> ServiceFinder<T> find(@NotNull Class<T> service2, @Nullable ClassLoader loader) {
        return ServiceFinder.find(service2, loader, ContainerResolver.getInstance().getContainer());
    }

    public static <T> ServiceFinder<T> find(Class<T> service2) {
        return ServiceFinder.find(service2, Thread.currentThread().getContextClassLoader());
    }

    private ServiceFinder(Class<T> service2, ClassLoader loader, Component component) {
        this.serviceClass = service2;
        this.classLoader = loader;
        this.component = ServiceFinder.getComponentEx(component);
    }

    private static ServiceName[] serviceClassNames(Class serviceClass, ClassLoader classLoader) {
        ArrayList<ServiceName> l = new ArrayList<ServiceName>();
        ServiceNameIterator it = new ServiceNameIterator(serviceClass, classLoader);
        while (it.hasNext()) {
            l.add((ServiceName)it.next());
        }
        return l.toArray(new ServiceName[l.size()]);
    }

    @Override
    public Iterator<T> iterator() {
        LazyIterator it = new LazyIterator(this.serviceClass, this.classLoader);
        return this.component != null ? new CompositeIterator(this.component.getIterableSPI(this.serviceClass).iterator(), it) : it;
    }

    public T[] toArray() {
        ArrayList<T> result = new ArrayList<T>();
        for (T t : this) {
            result.add(t);
        }
        return result.toArray((Object[])Array.newInstance(this.serviceClass, result.size()));
    }

    private static void fail(Class service2, String msg, Throwable cause) throws ServiceConfigurationError {
        ServiceConfigurationError sce = new ServiceConfigurationError(service2.getName() + ": " + msg);
        sce.initCause(cause);
        throw sce;
    }

    private static void fail(Class service2, String msg) throws ServiceConfigurationError {
        throw new ServiceConfigurationError(service2.getName() + ": " + msg);
    }

    private static void fail(Class service2, URL u, int line, String msg) throws ServiceConfigurationError {
        ServiceFinder.fail(service2, u + ":" + line + ": " + msg);
    }

    private static int parseLine(Class service2, URL u, BufferedReader r, int lc, List<String> names, Set<String> returned) throws IOException, ServiceConfigurationError {
        int n;
        String ln = r.readLine();
        if (ln == null) {
            return -1;
        }
        int ci = ln.indexOf(35);
        if (ci >= 0) {
            ln = ln.substring(0, ci);
        }
        if ((n = (ln = ln.trim()).length()) != 0) {
            int cp;
            if (ln.indexOf(32) >= 0 || ln.indexOf(9) >= 0) {
                ServiceFinder.fail(service2, u, lc, "Illegal configuration-file syntax");
            }
            if (!Character.isJavaIdentifierStart(cp = ln.codePointAt(0))) {
                ServiceFinder.fail(service2, u, lc, "Illegal provider-class name: " + ln);
            }
            for (int i = Character.charCount(cp); i < n; i += Character.charCount(cp)) {
                cp = ln.codePointAt(i);
                if (Character.isJavaIdentifierPart(cp) || cp == 46) continue;
                ServiceFinder.fail(service2, u, lc, "Illegal provider-class name: " + ln);
            }
            if (!returned.contains(ln)) {
                names.add(ln);
                returned.add(ln);
            }
        }
        return lc + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Iterator<String> parse(Class service2, URL u, Set<String> returned) throws ServiceConfigurationError {
        InputStream in = null;
        BufferedReader r = null;
        ArrayList<String> names = new ArrayList<String>();
        try {
            in = u.openStream();
            r = new BufferedReader(new InputStreamReader(in, "utf-8"));
            int lc = 1;
            while ((lc = ServiceFinder.parseLine(service2, u, r, lc, names, returned)) >= 0) {
            }
        }
        catch (IOException x) {
            ServiceFinder.fail(service2, ": " + x + ";URL is :" + u.toString());
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException y) {
                ServiceFinder.fail(service2, ": " + y + ";URL is :" + u.toString());
            }
        }
        return names.iterator();
    }

    private static ComponentEx getComponentEx(Component component) {
        if (component instanceof ComponentEx) {
            return (ComponentEx)component;
        }
        return component != null ? new ComponentExWrapper(component) : null;
    }

    private static class LazyIterator<T>
    implements Iterator<T> {
        Class<T> service;
        @Nullable
        ClassLoader loader;
        ServiceName[] names;
        int index;

        private LazyIterator(Class<T> service2, ClassLoader loader) {
            this.service = service2;
            this.loader = loader;
            this.names = null;
            this.index = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            if (this.names == null) {
                ConcurrentHashMap<String, ServiceName[]> nameMap = null;
                WeakHashMap weakHashMap = serviceNameCache;
                synchronized (weakHashMap) {
                    nameMap = (ConcurrentHashMap<String, ServiceName[]>)serviceNameCache.get(this.loader);
                }
                ServiceName[] serviceNameArray = this.names = nameMap != null ? (ServiceName[])nameMap.get(this.service.getName()) : null;
                if (this.names == null) {
                    this.names = ServiceFinder.serviceClassNames(this.service, this.loader);
                    if (nameMap == null) {
                        nameMap = new ConcurrentHashMap<String, ServiceName[]>();
                    }
                    nameMap.put(this.service.getName(), this.names);
                    weakHashMap = serviceNameCache;
                    synchronized (weakHashMap) {
                        serviceNameCache.put(this.loader, nameMap);
                    }
                }
            }
            return this.index < this.names.length;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ServiceName sn = this.names[this.index++];
            String cn = sn.className;
            URL currentConfig = sn.config;
            try {
                return this.service.cast(Class.forName(cn, true, this.loader).newInstance());
            }
            catch (ClassNotFoundException x) {
                ServiceFinder.fail(this.service, "Provider " + cn + " is specified in " + currentConfig + " but not found");
            }
            catch (Exception x) {
                ServiceFinder.fail(this.service, "Provider " + cn + " is specified in " + currentConfig + "but could not be instantiated: " + x, x);
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ServiceNameIterator
    implements Iterator<ServiceName> {
        Class service;
        @Nullable
        ClassLoader loader;
        Enumeration<URL> configs = null;
        Iterator<String> pending = null;
        Set<String> returned = new TreeSet<String>();
        String nextName = null;
        URL currentConfig = null;

        private ServiceNameIterator(Class service2, ClassLoader loader) {
            this.service = service2;
            this.loader = loader;
        }

        @Override
        public boolean hasNext() throws ServiceConfigurationError {
            if (this.nextName != null) {
                return true;
            }
            if (this.configs == null) {
                try {
                    String fullName = ServiceFinder.prefix + this.service.getName();
                    this.configs = this.loader == null ? ClassLoader.getSystemResources(fullName) : this.loader.getResources(fullName);
                }
                catch (IOException x) {
                    ServiceFinder.fail(this.service, ": " + x);
                }
            }
            while (this.pending == null || !this.pending.hasNext()) {
                if (!this.configs.hasMoreElements()) {
                    return false;
                }
                this.currentConfig = this.configs.nextElement();
                this.pending = ServiceFinder.parse(this.service, this.currentConfig, this.returned);
            }
            this.nextName = this.pending.next();
            return true;
        }

        @Override
        public ServiceName next() throws ServiceConfigurationError {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String cn = this.nextName;
            this.nextName = null;
            return new ServiceName(cn, this.currentConfig);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class CompositeIterator<T>
    implements Iterator<T> {
        private final Iterator<Iterator<T>> it;
        private Iterator<T> current = null;

        public CompositeIterator(Iterator<T> ... iterators) {
            this.it = Arrays.asList(iterators).iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.current != null && this.current.hasNext()) {
                return true;
            }
            while (this.it.hasNext()) {
                this.current = this.it.next();
                if (!this.current.hasNext()) continue;
                return true;
            }
            return false;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.current.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ComponentExWrapper
    implements ComponentEx {
        private final Component component;

        public ComponentExWrapper(Component component) {
            this.component = component;
        }

        @Override
        public <S> S getSPI(Class<S> spiType) {
            return this.component.getSPI(spiType);
        }

        @Override
        public <S> Iterable<S> getIterableSPI(Class<S> spiType) {
            S item = this.getSPI(spiType);
            if (item != null) {
                List<S> c = Collections.singletonList(item);
                return c;
            }
            return Collections.emptySet();
        }
    }

    private static class ServiceName {
        final String className;
        final URL config;

        public ServiceName(String className, URL config) {
            this.className = className;
            this.config = config;
        }
    }
}

