/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xservlet.servletstatus;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ELockType;
import com.helger.commons.annotation.MustBeLocked;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.UsedViaReflection;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.state.EChange;
import com.helger.scope.singleton.AbstractGlobalSingleton;
import com.helger.web.scope.IGlobalWebScope;
import com.helger.web.scope.mgr.WebScopeManager;
import com.helger.xservlet.servletstatus.EServletStatus;
import com.helger.xservlet.servletstatus.ServletStatus;
import java.lang.reflect.Modifier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.servlet.GenericServlet;
import javax.servlet.ServletRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class ServletStatusManager
extends AbstractGlobalSingleton {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServletStatusManager.class);
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<String, ServletStatus> m_aMap = new CommonsHashMap<String, ServletStatus>();

    @Deprecated
    @UsedViaReflection
    public ServletStatusManager() {
    }

    @Nonnull
    public static ServletStatusManager getInstance() {
        return ServletStatusManager.getGlobalSingleton(ServletStatusManager.class);
    }

    @Nullable
    public static ServletStatusManager getInstanceIfInstantiated() {
        return ServletStatusManager.getGlobalSingletonIfInstantiated(ServletStatusManager.class);
    }

    @Nonnull
    public EChange reset() {
        return this.m_aRWLock.writeLockedGet(this.m_aMap::removeAll);
    }

    @Nonnull
    @Nonempty
    private static String _getKey(@Nonnull Class<? extends GenericServlet> clazz) {
        return clazz.getName();
    }

    @Nonnull
    @MustBeLocked(value=ELockType.WRITE)
    private ServletStatus _getOrCreateServletStatus(@Nonnull Class<? extends GenericServlet> clazz) {
        ValueEnforcer.notNull(clazz, "Servlet class");
        if (Modifier.isAbstract(clazz.getModifiers())) {
            throw new IllegalStateException("Passed servlet class is abstract: " + clazz);
        }
        String string2 = ServletStatusManager._getKey(clazz);
        return this.m_aMap.computeIfAbsent(string2, string -> new ServletStatus(clazz.getName()));
    }

    private void _updateStatus(@Nonnull Class<? extends GenericServlet> clazz, @Nonnull EServletStatus eServletStatus) {
        ValueEnforcer.notNull(eServletStatus, "NewStatus");
        this.m_aRWLock.writeLocked(() -> this._getOrCreateServletStatus(clazz).internalSetCurrentStatus(eServletStatus));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Servlet status of " + clazz + " changed to " + eServletStatus);
        }
    }

    public void onServletCtor(@Nonnull Class<? extends GenericServlet> clazz) {
        this._updateStatus(clazz, EServletStatus.CONSTRUCTED);
    }

    public void onServletInit(@Nonnull Class<? extends GenericServlet> clazz) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("onServletInit: " + clazz);
        }
        this._updateStatus(clazz, EServletStatus.INITED);
    }

    public void onServletInitFailed(@Nonnull Exception exception, @Nonnull Class<? extends GenericServlet> clazz) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("onServletInitFailed: " + clazz, exception);
        }
        this._updateStatus(clazz, EServletStatus.CONSTRUCTED);
    }

    public void onServletInvocation(@Nonnull Class<? extends GenericServlet> clazz) {
        this.m_aRWLock.writeLocked(() -> this._getOrCreateServletStatus(clazz).internalIncrementInvocationCount());
    }

    public void onServletDestroy(@Nonnull Class<? extends GenericServlet> clazz) {
        this._updateStatus(clazz, EServletStatus.DESTROYED);
    }

    @Nullable
    public ServletStatus getStatus(@Nullable Class<? extends GenericServlet> clazz) {
        if (clazz == null) {
            return null;
        }
        String string = ServletStatusManager._getKey(clazz);
        return this.m_aRWLock.readLockedGet(() -> (ServletStatus)this.m_aMap.get(string));
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<String, ServletStatus> getAllStatus() {
        return this.m_aRWLock.readLockedGet(this.m_aMap::getClone);
    }

    public boolean isServletRegistered(@Nonnull Class<? extends GenericServlet> clazz) {
        String string = ValueEnforcer.notNull(clazz, "ServletClass").getName();
        IGlobalWebScope iGlobalWebScope = WebScopeManager.getGlobalScopeOrNull();
        if (iGlobalWebScope != null) {
            try {
                for (ServletRegistration servletRegistration : iGlobalWebScope.getServletContext().getServletRegistrations().values()) {
                    if (!servletRegistration.getClassName().equals(string)) continue;
                    return true;
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return false;
    }
}

