/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xservlet.servletstatus;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsEnumMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.string.ToStringGenerator;
import com.helger.xservlet.servletstatus.EServletStatus;
import java.time.LocalDateTime;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class ServletStatus {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServletStatus.class);
    private final String m_sClassName;
    private EServletStatus m_eCurrentStatus;
    private final ICommonsMap<EServletStatus, LocalDateTime> m_aStatusChangeDates = new CommonsEnumMap<EServletStatus, LocalDateTime>(EServletStatus.class);
    private final AtomicInteger m_aInvocationCount = new AtomicInteger(0);

    public ServletStatus(@Nonnull @Nonempty String string) {
        this.m_sClassName = ValueEnforcer.notEmpty(string, "ClassName");
    }

    @Nonnull
    @Nonempty
    public String getClassName() {
        return this.m_sClassName;
    }

    @Nullable
    public EServletStatus getCurrentStatus() {
        return this.m_eCurrentStatus;
    }

    void internalSetCurrentStatus(@Nonnull EServletStatus eServletStatus) {
        ValueEnforcer.notNull(eServletStatus, "NewStatus");
        if (!EServletStatus.isValidSuccessorOf(this.m_eCurrentStatus, eServletStatus) && LOGGER.isErrorEnabled()) {
            LOGGER.error("The new status " + eServletStatus + " is not a valid successor of the old status " + this.m_eCurrentStatus + " for " + this.m_sClassName);
        }
        this.m_eCurrentStatus = ValueEnforcer.notNull(eServletStatus, "NewStatus");
        this.m_aStatusChangeDates.put(eServletStatus, PDTFactory.getCurrentLocalDateTime());
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<EServletStatus, LocalDateTime> getStatusChangeMap() {
        return (ICommonsMap)this.m_aStatusChangeDates.getClone();
    }

    @Nullable
    public LocalDateTime getDateTimeOfStatus(@Nonnull EServletStatus eServletStatus) {
        return eServletStatus == null ? null : (LocalDateTime)this.m_aStatusChangeDates.get(eServletStatus);
    }

    void internalIncrementInvocationCount() {
        this.m_aInvocationCount.incrementAndGet();
    }

    @Nonnegative
    public int getInvocationCount() {
        return this.m_aInvocationCount.get();
    }

    public String toString() {
        return new ToStringGenerator(this).append("ClassName", this.m_sClassName).append("CurrentStatus", this.m_eCurrentStatus).append("StatusChangeDates", this.m_aStatusChangeDates).append("InvocationCount", this.m_aInvocationCount.get()).getToString();
    }
}

