/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xservlet.requesttrack;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.string.ToStringGenerator;
import com.helger.web.scope.IRequestWebScope;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TrackedRequest {
    private final String m_sRequestID;
    private final IRequestWebScope m_aRequestScope;
    private final long m_nStartMillis;

    public TrackedRequest(@Nonnull @Nonempty String string, @Nonnull IRequestWebScope iRequestWebScope) {
        this.m_sRequestID = ValueEnforcer.notEmpty(string, "RequestID");
        this.m_aRequestScope = ValueEnforcer.notNull(iRequestWebScope, "RequestScope");
        this.m_nStartMillis = System.currentTimeMillis();
    }

    @Nonnull
    @Nonempty
    public String getRequestID() {
        return this.m_sRequestID;
    }

    @Nonnull
    public IRequestWebScope getRequestScope() {
        return this.m_aRequestScope;
    }

    @Nonnegative
    public long getStartTimeMilliseconds() {
        return this.m_nStartMillis;
    }

    @Nonnegative
    public long getRunningMilliseconds() {
        return System.currentTimeMillis() - this.m_nStartMillis;
    }

    public String toString() {
        return new ToStringGenerator(this).append("RequestID", this.m_sRequestID).append("RequestScope", this.m_aRequestScope).append("StartMillis", this.m_nStartMillis).getToString();
    }
}

