/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xservlet.requesttrack;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.annotation.UsedViaReflection;
import com.helger.commons.callback.CallbackList;
import com.helger.commons.concurrent.BasicThreadFactory;
import com.helger.commons.concurrent.ExecutorServiceHelper;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.scope.IScope;
import com.helger.servlet.mock.OfflineHttpServletRequest;
import com.helger.web.scope.IGlobalWebScope;
import com.helger.web.scope.IRequestWebScope;
import com.helger.web.scope.mgr.WebScopeManager;
import com.helger.web.scope.mgr.WebScoped;
import com.helger.web.scope.singleton.AbstractGlobalWebSingleton;
import com.helger.xservlet.requesttrack.ILongRunningRequestCallback;
import com.helger.xservlet.requesttrack.IParallelRunningRequestCallback;
import com.helger.xservlet.requesttrack.LoggingLongRunningRequestCallback;
import com.helger.xservlet.requesttrack.LoggingParallelRunningRequestCallback;
import com.helger.xservlet.requesttrack.RequestTrackingManager;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class RequestTracker
extends AbstractGlobalWebSingleton {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestTracker.class);
    private static final CallbackList<ILongRunningRequestCallback> s_aLongRunningCallbacks = new CallbackList();
    private static final CallbackList<IParallelRunningRequestCallback> s_aParallelRunningCallbacks = new CallbackList();
    private final RequestTrackingManager m_aRequestTrackingMgr = new RequestTrackingManager();
    private final ScheduledExecutorService m_aExecSvc = Executors.newSingleThreadScheduledExecutor(new BasicThreadFactory.Builder().setNamingPattern("RequestTrackerMonitor-%d").setDaemon(true).build());

    @Nonnull
    @ReturnsMutableObject
    public static CallbackList<ILongRunningRequestCallback> longRunningRequestCallbacks() {
        return s_aLongRunningCallbacks;
    }

    @Nonnull
    @ReturnsMutableObject
    public static CallbackList<IParallelRunningRequestCallback> parallelRunningRequestCallbacks() {
        return s_aParallelRunningCallbacks;
    }

    @Deprecated
    @UsedViaReflection
    public RequestTracker() {
        this.m_aExecSvc.scheduleAtFixedRate(new RequestTrackerMonitor(), 0L, 2L, TimeUnit.SECONDS);
        LOGGER.info("RequestTrackerMonitor was installed successfully.");
    }

    @Override
    protected void onDestroy(@Nonnull IScope iScope) {
        LOGGER.info("RequestTrackerMonitor is now shutting down");
        ExecutorServiceHelper.shutdownAndWaitUntilAllTasksAreFinished(this.m_aExecSvc);
        LOGGER.info("RequestTrackerMonitor was uninstalled successfully.");
    }

    @Nonnull
    public static RequestTracker getInstance() {
        return RequestTracker.getGlobalSingleton(RequestTracker.class);
    }

    @Nonnull
    public RequestTrackingManager getRequestTrackingMgr() {
        return this.m_aRequestTrackingMgr;
    }

    @Nonnull
    public ScheduledExecutorService getExecutorService() {
        return this.m_aExecSvc;
    }

    public static void addRequest(@Nonnull @Nonempty String string, @Nonnull IRequestWebScope iRequestWebScope) {
        RequestTracker.getInstance().m_aRequestTrackingMgr.addRequest(string, iRequestWebScope, s_aParallelRunningCallbacks);
    }

    public static void removeRequest(@Nonnull @Nonempty String string) {
        RequestTracker requestTracker = RequestTracker.getGlobalSingletonIfInstantiated(RequestTracker.class);
        if (requestTracker != null) {
            requestTracker.m_aRequestTrackingMgr.removeRequest(string, s_aParallelRunningCallbacks);
        }
    }

    static {
        s_aLongRunningCallbacks.add(new LoggingLongRunningRequestCallback(EErrorLevel.ERROR));
        s_aParallelRunningCallbacks.add(new LoggingParallelRunningRequestCallback(EErrorLevel.WARN));
    }

    private final class RequestTrackerMonitor
    implements Runnable {
        private final IGlobalWebScope m_aGlobalScope = WebScopeManager.getGlobalScope();

        @Override
        public void run() {
            if (this.m_aGlobalScope.isValid()) {
                OfflineHttpServletRequest offlineHttpServletRequest = new OfflineHttpServletRequest(this.m_aGlobalScope.getServletContext(), false);
                try (WebScoped webScoped = new WebScoped(offlineHttpServletRequest);){
                    RequestTracker.this.m_aRequestTrackingMgr.checkForLongRunningRequests(s_aLongRunningCallbacks);
                }
                catch (Exception exception) {
                    LOGGER.error("Error checking for long running requests", exception);
                }
            }
        }
    }
}

