/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xservlet.requesttrack;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.log.LogHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.xservlet.requesttrack.IParallelRunningRequestCallback;
import com.helger.xservlet.requesttrack.TrackedRequest;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingParallelRunningRequestCallback
implements IParallelRunningRequestCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingParallelRunningRequestCallback.class);
    private IErrorLevel m_aErrorLevel;

    public LoggingParallelRunningRequestCallback() {
        this(EErrorLevel.WARN);
    }

    public LoggingParallelRunningRequestCallback(@Nonnull IErrorLevel iErrorLevel) {
        this.setErrorLevel(iErrorLevel);
    }

    @Nonnull
    public IErrorLevel getErrorLevel() {
        return this.m_aErrorLevel;
    }

    @Nonnull
    public LoggingParallelRunningRequestCallback setErrorLevel(@Nonnull IErrorLevel iErrorLevel) {
        this.m_aErrorLevel = ValueEnforcer.notNull(iErrorLevel, "ErrorLevel");
        return this;
    }

    @Override
    public void onParallelRunningRequests(@Nonnegative int n, @Nonnull @Nonempty List<TrackedRequest> list) {
        LogHelper.log(LOGGER, this.m_aErrorLevel, "Currently " + n + " parallel requests are active!");
    }

    @Override
    public void onParallelRunningRequestsBelowLimit() {
        LogHelper.log(LOGGER, this.m_aErrorLevel, "Parallel requests are back to normal!");
    }

    public String toString() {
        return new ToStringGenerator(this).append("errorLevel", this.m_aErrorLevel).getToString();
    }
}

