/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xsds.bdxr.smp2.ac;

import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.xsds.bdxr.smp2.ac.EndpointType;
import com.helger.xsds.bdxr.smp2.ac.ProcessType;
import com.helger.xsds.bdxr.smp2.ac.RedirectType;
import com.helger.xsds.bdxr.smp2.ec.SMPExtensionsType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ProcessMetadataType", propOrder={"smpExtensions", "process", "endpoint", "redirect"})
@CodingStyleguideUnaware
public class ProcessMetadataType
implements Serializable,
IExplicitlyCloneable {
    @XmlElement(name="SMPExtensions", namespace="http://docs.oasis-open.org/bdxr/ns/SMP/2/ExtensionComponents")
    private SMPExtensionsType smpExtensions;
    @XmlElement(name="Process")
    private List<ProcessType> process;
    @XmlElement(name="Endpoint")
    private List<EndpointType> endpoint;
    @XmlElement(name="Redirect")
    private RedirectType redirect;

    @Nullable
    public SMPExtensionsType getSMPExtensions() {
        return this.smpExtensions;
    }

    public void setSMPExtensions(@Nullable SMPExtensionsType sMPExtensionsType) {
        this.smpExtensions = sMPExtensionsType;
    }

    @Nonnull
    @ReturnsMutableObject(value="JAXB implementation style")
    public List<ProcessType> getProcess() {
        if (this.process == null) {
            this.process = new ArrayList<ProcessType>();
        }
        return this.process;
    }

    @Nonnull
    @ReturnsMutableObject(value="JAXB implementation style")
    public List<EndpointType> getEndpoint() {
        if (this.endpoint == null) {
            this.endpoint = new ArrayList<EndpointType>();
        }
        return this.endpoint;
    }

    @Nullable
    public RedirectType getRedirect() {
        return this.redirect;
    }

    public void setRedirect(@Nullable RedirectType redirectType) {
        this.redirect = redirectType;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ProcessMetadataType processMetadataType = (ProcessMetadataType)object;
        if (!EqualsHelper.equalsCollection(this.endpoint, processMetadataType.endpoint)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(this.process, processMetadataType.process)) {
            return false;
        }
        if (!EqualsHelper.equals(this.redirect, processMetadataType.redirect)) {
            return false;
        }
        return EqualsHelper.equals(this.smpExtensions, processMetadataType.smpExtensions);
    }

    public int hashCode() {
        return ((HashCodeGenerator)((HashCodeGenerator)new HashCodeGenerator(this).append(this.endpoint)).append(this.process)).append(this.redirect).append(this.smpExtensions).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("endpoint", this.endpoint).append("process", this.process).append("redirect", this.redirect).append("smpExtensions", this.smpExtensions).getToString();
    }

    public void setProcess(@Nullable List<ProcessType> list) {
        this.process = list;
    }

    public void setEndpoint(@Nullable List<EndpointType> list) {
        this.endpoint = list;
    }

    public boolean hasProcessEntries() {
        return !this.getProcess().isEmpty();
    }

    public boolean hasNoProcessEntries() {
        return this.getProcess().isEmpty();
    }

    @Nonnegative
    public int getProcessCount() {
        return this.getProcess().size();
    }

    @Nullable
    public ProcessType getProcessAtIndex(@Nonnegative int n) throws IndexOutOfBoundsException {
        return this.getProcess().get(n);
    }

    public void addProcess(@Nonnull ProcessType processType) {
        this.getProcess().add(processType);
    }

    public boolean hasEndpointEntries() {
        return !this.getEndpoint().isEmpty();
    }

    public boolean hasNoEndpointEntries() {
        return this.getEndpoint().isEmpty();
    }

    @Nonnegative
    public int getEndpointCount() {
        return this.getEndpoint().size();
    }

    @Nullable
    public EndpointType getEndpointAtIndex(@Nonnegative int n) throws IndexOutOfBoundsException {
        return this.getEndpoint().get(n);
    }

    public void addEndpoint(@Nonnull EndpointType endpointType) {
        this.getEndpoint().add(endpointType);
    }

    public void cloneTo(@Nonnull ProcessMetadataType processMetadataType) {
        ArrayList<EndpointType> arrayList;
        if (this.endpoint == null) {
            processMetadataType.endpoint = null;
        } else {
            arrayList = new ArrayList<EndpointType>();
            for (EndpointType iExplicitlyCloneable : this.getEndpoint()) {
                arrayList.add(iExplicitlyCloneable == null ? null : iExplicitlyCloneable.clone());
            }
            processMetadataType.endpoint = arrayList;
        }
        if (this.process == null) {
            processMetadataType.process = null;
        } else {
            arrayList = new ArrayList();
            for (ProcessType processType : this.getProcess()) {
                arrayList.add((EndpointType)((Object)(processType == null ? null : processType.clone())));
            }
            processMetadataType.process = arrayList;
        }
        processMetadataType.redirect = this.redirect == null ? null : this.redirect.clone();
        processMetadataType.smpExtensions = this.smpExtensions == null ? null : this.smpExtensions.clone();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ProcessMetadataType clone() {
        ProcessMetadataType processMetadataType = new ProcessMetadataType();
        this.cloneTo(processMetadataType);
        return processMetadataType;
    }
}

