/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.transform;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.io.EAppend;
import com.helger.commons.io.IHasOutputStream;
import com.helger.commons.io.resource.IWritableResource;
import com.helger.commons.string.ToStringGenerator;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.transform.stream.StreamResult;

@NotThreadSafe
public class ResourceStreamResult
extends StreamResult {
    private final IHasOutputStream m_aOSP;

    public ResourceStreamResult(@Nonnull IWritableResource iWritableResource) {
        this(iWritableResource, iWritableResource.getResourceID());
    }

    public ResourceStreamResult(@Nonnull IHasOutputStream iHasOutputStream, @Nullable String string) {
        this.m_aOSP = ValueEnforcer.notNull(iHasOutputStream, "OutputStreamProvider");
        this.setSystemId(string);
    }

    @Override
    public OutputStream getOutputStream() {
        OutputStream outputStream = this.m_aOSP.getOutputStream(EAppend.TRUNCATE);
        if (outputStream == null) {
            throw new IllegalStateException("Failed to open output stream for " + this.m_aOSP);
        }
        return outputStream;
    }

    public String toString() {
        return new ToStringGenerator(this).append("OSP", this.m_aOSP).append("systemID", this.getSystemId()).getToString();
    }
}

