/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.schema;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.cache.Cache;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.xml.transform.TransformSourceFactory;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

@ThreadSafe
public class SchemaCache
extends Cache<ICommonsList<? extends IReadableResource>, Schema> {
    private final String m_sSchemaTypeName;
    private final SchemaFactory m_aSchemaFactory;

    public SchemaCache(@Nonnull String string, @Nonnull SchemaFactory schemaFactory, @Nullable ErrorHandler errorHandler, @Nullable LSResourceResolver lSResourceResolver) {
        super(iCommonsList -> SchemaCache.createSchema(schemaFactory, string, iCommonsList), 500, SchemaCache.class.getName() + "$" + string);
        ValueEnforcer.notNull(string, "SchemaTypeName");
        ValueEnforcer.notNull(schemaFactory, "SchemaFactory");
        this.m_sSchemaTypeName = string;
        this.m_aSchemaFactory = schemaFactory;
        this.m_aSchemaFactory.setErrorHandler(errorHandler);
        this.m_aSchemaFactory.setResourceResolver(lSResourceResolver);
    }

    @Nonnull
    public final String getSchemaTypeName() {
        return this.m_sSchemaTypeName;
    }

    @Nonnull
    public final SchemaFactory getSchemaFactory() {
        return this.m_aSchemaFactory;
    }

    @Nullable
    public ErrorHandler getErrorHandler() {
        return this.m_aSchemaFactory.getErrorHandler();
    }

    @Nullable
    public LSResourceResolver getResourceResolver() {
        return this.m_aSchemaFactory.getResourceResolver();
    }

    @Nonnull
    public static Schema createSchema(@Nonnull SchemaFactory schemaFactory, @Nonnull String string, @Nonnull @Nonempty ICommonsList<? extends IReadableResource> iCommonsList) {
        ValueEnforcer.notNull(schemaFactory, "SchemaFactory");
        ValueEnforcer.notEmptyNoNullValue(iCommonsList, "Resources");
        Source[] sourceArray = new Source[iCommonsList.size()];
        for (int i = 0; i < iCommonsList.size(); ++i) {
            sourceArray[i] = TransformSourceFactory.create((IReadableResource)iCommonsList.get(i));
        }
        try {
            Schema schema2 = schemaFactory.newSchema(sourceArray);
            if (schema2 == null) {
                throw new IllegalStateException("Failed to create " + string + " schema from " + iCommonsList.toString());
            }
            return schema2;
        }
        catch (SAXException sAXException) {
            throw new IllegalArgumentException("Failed to parse " + string + " from " + iCommonsList.toString(), sAXException);
        }
    }

    @Nonnull
    public final Schema getSchema(@Nonnull IReadableResource iReadableResource) {
        ValueEnforcer.notNull(iReadableResource, "Resource");
        return (Schema)this.getFromCache(new CommonsArrayList<IReadableResource>(iReadableResource));
    }

    @Nonnull
    public final Schema getSchema(IReadableResource ... iReadableResourceArray) {
        ValueEnforcer.notEmptyNoNullValue(iReadableResourceArray, "Resources");
        return (Schema)this.getFromCache(new CommonsArrayList<IReadableResource>(iReadableResourceArray));
    }

    @Nonnull
    public final Schema getSchema(@Nonnull @Nonempty Collection<? extends IReadableResource> collection) {
        ValueEnforcer.notEmptyNoNullValue(collection, "Resources");
        return (Schema)this.getFromCache(new CommonsArrayList<Collection<? extends IReadableResource>>(collection));
    }

    @Nonnull
    public final Validator getValidatorFromSchema(@Nonnull Schema schema2) {
        ValueEnforcer.notNull(schema2, "Schema");
        Validator validator = schema2.newValidator();
        validator.setErrorHandler(this.m_aSchemaFactory.getErrorHandler());
        return validator;
    }

    @Nonnull
    public final Validator getValidator(@Nonnull IReadableResource iReadableResource) {
        return this.getValidatorFromSchema(this.getSchema(iReadableResource));
    }

    @Nonnull
    public final Validator getValidator(IReadableResource ... iReadableResourceArray) {
        return this.getValidatorFromSchema(this.getSchema(iReadableResourceArray));
    }

    @Nonnull
    public final Validator getValidator(@Nonnull @Nonempty Collection<? extends IReadableResource> collection) {
        return this.getValidatorFromSchema(this.getSchema(collection));
    }

    @Override
    @Nonnull
    public EChange removeFromCache(@Nonnull IReadableResource iReadableResource) {
        return this.removeFromCache(new CommonsArrayList<IReadableResource>(iReadableResource));
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("schemaTypeName", this.m_sSchemaTypeName).getToString();
    }
}

